/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class SpatialSchemaKey
implements NativeSchemaKey {
    static final int SIZE = 16;
    private long entityId;
    private boolean compareId;
    long rawValueBits;
    CoordinateReferenceSystem crs;
    SpaceFillingCurve curve;

    SpatialSchemaKey(CoordinateReferenceSystem crs, SpaceFillingCurve curve) {
        this.crs = crs;
        this.curve = curve;
    }

    @Override
    public void setCompareId(boolean entityIdIsSpecialTieBreaker) {
        this.compareId = entityIdIsSpecialTieBreaker;
    }

    @Override
    public boolean getCompareId() {
        return this.compareId;
    }

    @Override
    public long getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    @Override
    public void from(long entityId, Value ... values) {
        this.extractRawBits(this.assertValidValue(values));
        this.entityId = entityId;
        this.compareId = false;
    }

    @Override
    public String propertiesAsString() {
        return this.asValue().toString();
    }

    public NumberValue asValue() {
        return (NumberValue)Values.of((Object)this.rawValueBits);
    }

    @Override
    public void initAsLowest() {
        double[] limit = new double[this.crs.getDimension()];
        Arrays.fill(limit, Double.NEGATIVE_INFINITY);
        this.writePoint(limit);
        this.entityId = Long.MIN_VALUE;
        this.compareId = true;
    }

    @Override
    public void initAsHighest() {
        double[] limit = new double[this.crs.getDimension()];
        Arrays.fill(limit, Double.NEGATIVE_INFINITY);
        limit[0] = Double.POSITIVE_INFINITY;
        this.writePoint(limit);
        this.entityId = Long.MAX_VALUE;
        this.compareId = true;
    }

    public void fromDerivedValue(long entityId, long derivedValue) {
        this.rawValueBits = derivedValue;
        this.entityId = entityId;
        this.compareId = false;
    }

    int compareValueTo(SpatialSchemaKey other) {
        return Long.compare(this.rawValueBits, other.rawValueBits);
    }

    private PointValue assertValidValue(Value ... values) {
        if (values.length > 1) {
            throw new IllegalArgumentException("Tried to create composite key with non-composite schema key layout");
        }
        if (values.length < 1) {
            throw new IllegalArgumentException("Tried to create key without value");
        }
        if (!Values.isGeometryValue((Value)values[0])) {
            throw new IllegalArgumentException("Key layout does only support geometries, tried to create key from " + values[0]);
        }
        return (PointValue)values[0];
    }

    private void extractRawBits(PointValue value) {
        this.writePoint(value.coordinate());
    }

    private void writePoint(double[] coordinate) {
        this.rawValueBits = this.curve.derivedValueFor(coordinate);
    }

    @Override
    public String toString() {
        return String.format("rawValue=%d,value=%s,entityId=%d", this.rawValueBits, "unknown", this.entityId);
    }
}

