/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.SpatialSchemaKey;
import org.neo4j.values.storable.CoordinateReferenceSystem;

abstract class SpatialLayout
extends Layout.Adapter<SpatialSchemaKey, NativeSchemaValue> {
    private SpaceFillingCurve curve;
    CoordinateReferenceSystem crs;

    SpatialLayout(CoordinateReferenceSystem crs, SpaceFillingCurve curve) {
        this.crs = crs;
        this.curve = curve;
    }

    SpaceFillingCurve getSpaceFillingCurve() {
        return this.curve;
    }

    public SpatialSchemaKey newKey() {
        return new SpatialSchemaKey(this.crs, this.curve);
    }

    public SpatialSchemaKey copyKey(SpatialSchemaKey key, SpatialSchemaKey into) {
        into.rawValueBits = key.rawValueBits;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        into.crs = key.crs;
        into.curve = key.curve;
        return into;
    }

    public NativeSchemaValue newValue() {
        return NativeSchemaValue.INSTANCE;
    }

    public int keySize(SpatialSchemaKey key) {
        return 16;
    }

    public int valueSize(NativeSchemaValue value) {
        return 0;
    }

    public void writeKey(PageCursor cursor, SpatialSchemaKey key) {
        cursor.putLong(key.rawValueBits);
        cursor.putLong(key.getEntityId());
    }

    public void writeValue(PageCursor cursor, NativeSchemaValue value) {
    }

    public void readKey(PageCursor cursor, SpatialSchemaKey into, int keySize) {
        into.rawValueBits = cursor.getLong();
        into.setEntityId(cursor.getLong());
    }

    public void readValue(PageCursor cursor, NativeSchemaValue into, int valueSize) {
    }

    public boolean fixedSize() {
        return true;
    }
}

