/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.CapabilityValidator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.kernel.impl.index.schema.NumberSchemaIndexProvider;
import org.neo4j.kernel.impl.index.schema.NumberSchemaKey;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class NumberSchemaIndexReader<KEY extends NumberSchemaKey, VALUE extends NativeSchemaValue>
extends NativeSchemaIndexReader<KEY, VALUE> {
    NumberSchemaIndexReader(GBPTree<KEY, VALUE> tree, Layout<KEY, VALUE> layout, IndexSamplingConfig samplingConfig, IndexDescriptor descriptor) {
        super(tree, layout, samplingConfig, descriptor);
    }

    @Override
    void validateQuery(IndexOrder indexOrder, IndexQuery[] predicates) {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException();
        }
        CapabilityValidator.validateQuery(NumberSchemaIndexProvider.CAPABILITY, indexOrder, predicates);
    }

    @Override
    void initializeRangeForQuery(KEY treeKeyFrom, KEY treeKeyTo, IndexQuery[] predicates) {
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                ((NumberSchemaKey)treeKeyFrom).initAsLowest();
                ((NumberSchemaKey)treeKeyTo).initAsHighest();
                break;
            }
            case exact: {
                IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                ((NumberSchemaKey)treeKeyFrom).from(Long.MIN_VALUE, exactPredicate.value());
                ((NumberSchemaKey)treeKeyTo).from(Long.MAX_VALUE, exactPredicate.value());
                break;
            }
            case rangeNumeric: {
                IndexQuery.NumberRangePredicate rangePredicate = (IndexQuery.NumberRangePredicate)predicate;
                this.initFromForRange(rangePredicate, treeKeyFrom);
                this.initToForRange(rangePredicate, treeKeyTo);
                break;
            }
            default: {
                throw new IllegalArgumentException("IndexQuery of type " + predicate.type() + " is not supported.");
            }
        }
    }

    private void initToForRange(IndexQuery.NumberRangePredicate rangePredicate, KEY treeKeyTo) {
        Value toValue = rangePredicate.toAsValue();
        if (toValue.valueGroup() == ValueGroup.NO_VALUE) {
            ((NumberSchemaKey)treeKeyTo).initAsHighest();
        } else {
            ((NumberSchemaKey)treeKeyTo).from(rangePredicate.toInclusive() ? Long.MAX_VALUE : Long.MIN_VALUE, toValue);
            ((NumberSchemaKey)treeKeyTo).setCompareId(true);
        }
    }

    private void initFromForRange(IndexQuery.NumberRangePredicate rangePredicate, KEY treeKeyFrom) {
        Value fromValue = rangePredicate.fromAsValue();
        if (fromValue.valueGroup() == ValueGroup.NO_VALUE) {
            ((NumberSchemaKey)treeKeyFrom).initAsLowest();
        } else {
            ((NumberSchemaKey)treeKeyFrom).from(rangePredicate.fromInclusive() ? Long.MIN_VALUE : Long.MAX_VALUE, fromValue);
            ((NumberSchemaKey)treeKeyFrom).setCompareId(true);
        }
    }

    @Override
    public boolean hasFullValuePrecision(IndexQuery ... predicates) {
        return true;
    }
}

