/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;

class DateSchemaKey
extends ValueWriter.Adapter<RuntimeException>
implements NativeSchemaKey {
    static final int SIZE = 16;
    private long entityId;
    private boolean compareId;
    long epochDay;

    DateSchemaKey() {
    }

    @Override
    public void setCompareId(boolean compareId) {
        this.compareId = compareId;
    }

    @Override
    public boolean getCompareId() {
        return this.compareId;
    }

    @Override
    public long getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    @Override
    public void from(long entityId, Value ... values) {
        this.entityId = entityId;
        this.compareId = false;
        this.assertValidValue(values).writeTo((ValueWriter)this);
    }

    private DateValue assertValidValue(Value ... values) {
        if (values.length > 1) {
            throw new IllegalArgumentException("Tried to create composite key with non-composite schema key layout");
        }
        if (values.length < 1) {
            throw new IllegalArgumentException("Tried to create key without value");
        }
        if (!(values[0] instanceof DateValue)) {
            throw new IllegalArgumentException("Key layout does only support DateValue, tried to create key from " + values[0]);
        }
        return (DateValue)values[0];
    }

    @Override
    public String propertiesAsString() {
        return this.asValue().toString();
    }

    @Override
    public Value asValue() {
        return DateValue.epochDate((long)this.epochDay);
    }

    @Override
    public void initAsLowest() {
        this.epochDay = Long.MIN_VALUE;
        this.entityId = Long.MIN_VALUE;
        this.compareId = true;
    }

    @Override
    public void initAsHighest() {
        this.epochDay = Long.MAX_VALUE;
        this.entityId = Long.MAX_VALUE;
        this.compareId = true;
    }

    int compareValueTo(DateSchemaKey other) {
        return Long.compare(this.epochDay, other.epochDay);
    }

    @Override
    public String toString() {
        return String.format("value=%s,entityId=%d,epochDay=%s", this.asValue(), this.entityId, this.epochDay);
    }

    public void writeDate(long epochDay) {
        this.epochDay = epochDay;
    }
}

