/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.impl.index.schema.NativeSchemaKey;
import org.neo4j.kernel.impl.index.schema.NativeSchemaValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

abstract class ConflictDetectingValueMerger<KEY extends NativeSchemaKey, VALUE extends NativeSchemaValue>
implements ValueMerger<KEY, VALUE> {
    private static ConflictDetectingValueMerger DONT_CHECK = new ConflictDetectingValueMerger(){

        public Object merge(Object existingKey, Object newKey, Object existingValue, Object newValue) {
            return null;
        }

        @Override
        void checkConflict(Value[] values) {
        }
    };

    ConflictDetectingValueMerger() {
    }

    abstract void checkConflict(Value[] var1) throws IndexEntryConflictException;

    static <KEY extends NativeSchemaKey, VALUE extends NativeSchemaValue> ConflictDetectingValueMerger<KEY, VALUE> dontCheck() {
        return DONT_CHECK;
    }

    static class Check<KEY extends NativeSchemaKey, VALUE extends NativeSchemaValue>
    extends ConflictDetectingValueMerger<KEY, VALUE> {
        private boolean conflict;
        private long existingNodeId;
        private long addedNodeId;

        Check() {
        }

        public VALUE merge(KEY existingKey, KEY newKey, VALUE existingValue, VALUE newValue) {
            if (existingKey.getEntityId() != newKey.getEntityId()) {
                this.conflict = true;
                this.existingNodeId = existingKey.getEntityId();
                this.addedNodeId = newKey.getEntityId();
            }
            return null;
        }

        @Override
        void checkConflict(Value[] values) throws IndexEntryConflictException {
            if (this.conflict) {
                this.conflict = false;
                throw new IndexEntryConflictException(this.existingNodeId, this.addedNodeId, ValueTuple.of((Value[])values));
            }
        }
    }
}

