/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntObjectVisitor;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.schema.constaints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.txstate.RelationshipChangeVisitorAdapter;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.cursor.TxAllPropertyCursor;
import org.neo4j.kernel.impl.api.cursor.TxIteratorRelationshipCursor;
import org.neo4j.kernel.impl.api.cursor.TxSingleNodeCursor;
import org.neo4j.kernel.impl.api.cursor.TxSinglePropertyCursor;
import org.neo4j.kernel.impl.api.cursor.TxSingleRelationshipCursor;
import org.neo4j.kernel.impl.api.state.GraphState;
import org.neo4j.kernel.impl.api.state.NodeStateImpl;
import org.neo4j.kernel.impl.api.state.PropertyChanges;
import org.neo4j.kernel.impl.api.state.RelationshipStateImpl;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.kernel.impl.util.diffsets.DiffSets;
import org.neo4j.kernel.impl.util.diffsets.EmptyPrimitiveLongReadableDiffSets;
import org.neo4j.kernel.impl.util.diffsets.PrimitiveLongDiffSets;
import org.neo4j.kernel.impl.util.diffsets.RelationshipDiffSets;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.DiffSetsVisitor;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.PrimitiveLongReadableDiffSets;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.storageengine.api.txstate.ReadableDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableRelationshipDiffSets;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.RelationshipState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class TxState
implements TransactionState,
RelationshipVisitor.Home {
    private PrimitiveIntObjectMap<DiffSets<Long>> labelStatesMap;
    private PrimitiveLongObjectMap<NodeStateImpl> nodeStatesMap;
    private PrimitiveLongObjectMap<RelationshipStateImpl> relationshipStatesMap;
    private PrimitiveIntObjectMap<String> createdLabelTokens;
    private PrimitiveIntObjectMap<String> createdPropertyKeyTokens;
    private PrimitiveIntObjectMap<String> createdRelationshipTypeTokens;
    private GraphState graphState;
    private DiffSets<IndexDescriptor> indexChanges;
    private DiffSets<ConstraintDescriptor> constraintsChanges;
    private PropertyChanges propertyChangesForNodes;
    private RemovalsCountingDiffSets nodes;
    private RemovalsCountingRelationshipsDiffSets relationships;
    private Map<IndexBackedConstraintDescriptor, Long> createdConstraintIndexesByConstraint;
    private Map<LabelSchemaDescriptor, Map<ValueTuple, PrimitiveLongDiffSets>> indexUpdates;
    private InstanceCache<TxSingleNodeCursor> singleNodeCursor = new InstanceCache<TxSingleNodeCursor>(){

        @Override
        protected TxSingleNodeCursor create() {
            return new TxSingleNodeCursor(TxState.this, this);
        }
    };
    private InstanceCache<TxIteratorRelationshipCursor> iteratorRelationshipCursor;
    private InstanceCache<TxSingleRelationshipCursor> singleRelationshipCursor;
    private InstanceCache<TxAllPropertyCursor> propertyCursor = new InstanceCache<TxAllPropertyCursor>(){

        @Override
        protected TxAllPropertyCursor create() {
            return new TxAllPropertyCursor(this);
        }
    };
    private InstanceCache<TxSinglePropertyCursor> singlePropertyCursor = new InstanceCache<TxSinglePropertyCursor>(){

        @Override
        protected TxSinglePropertyCursor create() {
            return new TxSinglePropertyCursor(this);
        }
    };
    private boolean hasChanges;
    private boolean hasDataChanges;

    public TxState() {
        this.singleRelationshipCursor = new InstanceCache<TxSingleRelationshipCursor>(){

            @Override
            protected TxSingleRelationshipCursor create() {
                return new TxSingleRelationshipCursor((TransactionState)TxState.this, this);
            }
        };
        this.iteratorRelationshipCursor = new InstanceCache<TxIteratorRelationshipCursor>(){

            @Override
            protected TxIteratorRelationshipCursor create() {
                return new TxIteratorRelationshipCursor((TransactionState)TxState.this, this);
            }
        };
    }

    @Override
    public void accept(TxStateVisitor visitor) throws ConstraintValidationException, CreateConstraintFailureException {
        if (this.nodes != null) {
            this.nodes.accept((DiffSetsVisitor)TxState.createdNodesVisitor(visitor));
        }
        if (this.relationships != null) {
            this.relationships.accept((DiffSetsVisitor)TxState.createdRelationshipsVisitor(this, visitor));
            this.relationships.accept((DiffSetsVisitor)TxState.deletedRelationshipsVisitor(visitor));
        }
        if (this.nodes != null) {
            this.nodes.accept((DiffSetsVisitor)TxState.deletedNodesVisitor(visitor));
        }
        for (NodeState node : this.modifiedNodes()) {
            node.accept(TxState.nodeVisitor(visitor));
        }
        for (RelationshipState rel : this.modifiedRelationships()) {
            rel.accept(TxState.relVisitor(visitor));
        }
        if (this.graphState != null) {
            this.graphState.accept(TxState.graphPropertyVisitor(visitor));
        }
        if (this.indexChanges != null) {
            this.indexChanges.accept((DiffSetsVisitor)TxState.indexVisitor(visitor));
        }
        if (this.constraintsChanges != null) {
            this.constraintsChanges.accept((DiffSetsVisitor)TxState.constraintsVisitor(visitor));
        }
        if (this.createdLabelTokens != null) {
            this.createdLabelTokens.visitEntries((PrimitiveIntObjectVisitor)new LabelTokenStateVisitor(visitor));
        }
        if (this.createdPropertyKeyTokens != null) {
            this.createdPropertyKeyTokens.visitEntries((PrimitiveIntObjectVisitor)new PropertyKeyTokenStateVisitor(visitor));
        }
        if (this.createdRelationshipTypeTokens != null) {
            this.createdRelationshipTypeTokens.visitEntries((PrimitiveIntObjectVisitor)new RelationshipTypeTokenStateVisitor(visitor));
        }
    }

    private static DiffSetsVisitor<Long> deletedNodesVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor.Adapter<Long>(){

            @Override
            public void visitRemoved(Long element) {
                visitor.visitDeletedNode(element);
            }
        };
    }

    private static DiffSetsVisitor<Long> createdNodesVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor.Adapter<Long>(){

            @Override
            public void visitAdded(Long element) {
                visitor.visitCreatedNode(element);
            }
        };
    }

    private static DiffSetsVisitor<Long> deletedRelationshipsVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor.Adapter<Long>(){

            @Override
            public void visitRemoved(Long id) {
                visitor.visitDeletedRelationship(id);
            }
        };
    }

    private static DiffSetsVisitor<Long> createdRelationshipsVisitor(ReadableTransactionState tx, final TxStateVisitor visitor) {
        return new RelationshipChangeVisitorAdapter(tx){

            @Override
            protected void visitAddedRelationship(long relationshipId, int type, long startNode, long endNode) throws ConstraintValidationException {
                visitor.visitCreatedRelationship(relationshipId, type, startNode, endNode);
            }
        };
    }

    private static DiffSetsVisitor<ConstraintDescriptor> constraintsVisitor(TxStateVisitor visitor) {
        return new ConstraintDiffSetsVisitor(visitor);
    }

    private static DiffSetsVisitor<IndexDescriptor> indexVisitor(final TxStateVisitor visitor) {
        return new DiffSetsVisitor<IndexDescriptor>(){

            @Override
            public void visitAdded(IndexDescriptor index) {
                visitor.visitAddedIndex(index);
            }

            @Override
            public void visitRemoved(IndexDescriptor index) {
                visitor.visitRemovedIndex(index);
            }
        };
    }

    private static NodeState.Visitor nodeVisitor(final TxStateVisitor visitor) {
        return new NodeState.Visitor(){

            @Override
            public void visitLabelChanges(long nodeId, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationException {
                visitor.visitNodeLabelChanges(nodeId, added, removed);
            }

            @Override
            public void visitPropertyChanges(long entityId, Iterator<StorageProperty> added, Iterator<StorageProperty> changed, Iterator<Integer> removed) throws ConstraintValidationException {
                visitor.visitNodePropertyChanges(entityId, added, changed, removed);
            }
        };
    }

    private static PropertyContainerState.Visitor relVisitor(TxStateVisitor visitor) {
        return visitor::visitRelPropertyChanges;
    }

    private static PropertyContainerState.Visitor graphPropertyVisitor(TxStateVisitor visitor) {
        return (entityId, added, changed, removed) -> visitor.visitGraphPropertyChanges(added, changed, removed);
    }

    @Override
    public boolean hasChanges() {
        return this.hasChanges;
    }

    @Override
    public Iterable<NodeState> modifiedNodes() {
        return this.nodeStatesMap == null ? Iterables.empty() : Iterables.cast((Iterable)this.nodeStatesMap.values());
    }

    private DiffSets<Long> getOrCreateLabelStateNodeDiffSets(int labelId) {
        if (this.labelStatesMap == null) {
            this.labelStatesMap = Primitive.intObjectMap();
        }
        return (DiffSets)this.labelStatesMap.computeIfAbsent(labelId, unused -> new DiffSets());
    }

    private ReadableDiffSets<Long> getLabelStateNodeDiffSets(int labelId) {
        if (this.labelStatesMap == null) {
            return ReadableDiffSets.Empty.instance();
        }
        DiffSets nodeDiffSets = (DiffSets)this.labelStatesMap.get(labelId);
        return ReadableDiffSets.Empty.ifNull(nodeDiffSets);
    }

    @Override
    public ReadableDiffSets<Integer> nodeStateLabelDiffSets(long nodeId) {
        return this.getNodeState(nodeId).labelDiffSets();
    }

    private DiffSets<Integer> getOrCreateNodeStateLabelDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).getOrCreateLabelDiffSets();
    }

    @Override
    public Iterator<StorageProperty> augmentGraphProperties(Iterator<StorageProperty> original) {
        if (this.graphState != null) {
            return this.graphState.augmentProperties(original);
        }
        return original;
    }

    @Override
    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.nodes != null && this.nodes.isAdded((Object)nodeId);
    }

    @Override
    public boolean relationshipIsAddedInThisTx(long relationshipId) {
        return this.relationships != null && this.relationships.isAdded((Object)relationshipId);
    }

    private void changed() {
        this.hasChanges = true;
    }

    private void dataChanged() {
        this.changed();
        this.hasDataChanges = true;
    }

    @Override
    public void nodeDoCreate(long id) {
        this.nodes().add((Object)id);
        this.dataChanged();
    }

    @Override
    public void nodeDoDelete(long nodeId) {
        NodeStateImpl nodeState;
        this.nodes().remove(nodeId);
        if (this.nodeStatesMap != null && (nodeState = (NodeStateImpl)this.nodeStatesMap.remove(nodeId)) != null) {
            ReadableDiffSets<Integer> diff = nodeState.labelDiffSets();
            for (Integer label : diff.getAdded()) {
                this.getOrCreateLabelStateNodeDiffSets(label).remove((Object)nodeId);
            }
            nodeState.clearIndexDiffs(nodeId);
            nodeState.clear();
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoCreate(long id, int relationshipTypeId, long startNodeId, long endNodeId) {
        this.relationships().add((Object)id);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, Direction.BOTH);
        } else {
            this.getOrCreateNodeState(startNodeId).addRelationship(id, relationshipTypeId, Direction.OUTGOING);
            this.getOrCreateNodeState(endNodeId).addRelationship(id, relationshipTypeId, Direction.INCOMING);
        }
        this.getOrCreateRelationshipState(id).setMetaData(startNodeId, endNodeId, relationshipTypeId);
        this.dataChanged();
    }

    @Override
    public boolean nodeIsDeletedInThisTx(long nodeId) {
        return this.nodes != null && this.nodes.wasRemoved(nodeId);
    }

    @Override
    public boolean nodeModifiedInThisTx(long nodeId) {
        return this.nodeIsAddedInThisTx(nodeId) || this.nodeIsDeletedInThisTx(nodeId) || this.hasNodeState(nodeId);
    }

    @Override
    public void relationshipDoDelete(long id, int type, long startNodeId, long endNodeId) {
        RelationshipStateImpl removed;
        this.relationships().remove(id);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, Direction.BOTH);
        } else {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id, type, Direction.OUTGOING);
            this.getOrCreateNodeState(endNodeId).removeRelationship(id, type, Direction.INCOMING);
        }
        if (this.relationshipStatesMap != null && (removed = (RelationshipStateImpl)this.relationshipStatesMap.remove(id)) != null) {
            removed.clear();
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoDeleteAddedInThisTx(long relationshipId) {
        this.getRelationshipState(relationshipId).accept(this::relationshipDoDelete);
    }

    @Override
    public boolean relationshipIsDeletedInThisTx(long relationshipId) {
        return this.relationships != null && this.relationships.wasRemoved(relationshipId);
    }

    @Override
    public void nodeDoAddProperty(long nodeId, int newPropertyKeyId, Value value) {
        NodeStateImpl nodeState = this.getOrCreateNodeState(nodeId);
        nodeState.addProperty(newPropertyKeyId, value);
        this.nodePropertyChanges().addProperty(nodeId, newPropertyKeyId, value);
        this.dataChanged();
    }

    @Override
    public void nodeDoChangeProperty(long nodeId, int propertyKeyId, Value replacedValue, Value newValue) {
        this.getOrCreateNodeState(nodeId).changeProperty(propertyKeyId, newValue);
        this.nodePropertyChanges().changeProperty(nodeId, propertyKeyId, replacedValue, newValue);
        this.dataChanged();
    }

    @Override
    public void relationshipDoReplaceProperty(long relationshipId, int propertyKeyId, Value replacedValue, Value newValue) {
        if (replacedValue != Values.NO_VALUE) {
            this.getOrCreateRelationshipState(relationshipId).changeProperty(propertyKeyId, newValue);
        } else {
            this.getOrCreateRelationshipState(relationshipId).addProperty(propertyKeyId, newValue);
        }
        this.dataChanged();
    }

    @Override
    public void graphDoReplaceProperty(int propertyKeyId, Value replacedValue, Value newValue) {
        if (replacedValue != Values.NO_VALUE) {
            this.getOrCreateGraphState().changeProperty(propertyKeyId, newValue);
        } else {
            this.getOrCreateGraphState().addProperty(propertyKeyId, newValue);
        }
        this.dataChanged();
    }

    @Override
    public void nodeDoRemoveProperty(long nodeId, int propertyKeyId, Value removedValue) {
        this.getOrCreateNodeState(nodeId).removeProperty(propertyKeyId, removedValue);
        this.nodePropertyChanges().removeProperty(nodeId, propertyKeyId, removedValue);
        this.dataChanged();
    }

    @Override
    public void relationshipDoRemoveProperty(long relationshipId, int propertyKeyId, Value removedValue) {
        this.getOrCreateRelationshipState(relationshipId).removeProperty(propertyKeyId, removedValue);
        this.dataChanged();
    }

    @Override
    public void graphDoRemoveProperty(int propertyKeyId, Value removedValue) {
        this.getOrCreateGraphState().removeProperty(propertyKeyId, removedValue);
        this.dataChanged();
    }

    @Override
    public void nodeDoAddLabel(int labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).add((Object)nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).add((Object)labelId);
        this.dataChanged();
    }

    @Override
    public void nodeDoRemoveLabel(int labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).remove((Object)nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).remove((Object)labelId);
        this.dataChanged();
    }

    @Override
    public void labelDoCreateForName(String labelName, int id) {
        if (this.createdLabelTokens == null) {
            this.createdLabelTokens = Primitive.intObjectMap();
        }
        this.createdLabelTokens.put(id, (Object)labelName);
        this.changed();
    }

    @Override
    public void propertyKeyDoCreateForName(String propertyKeyName, int id) {
        if (this.createdPropertyKeyTokens == null) {
            this.createdPropertyKeyTokens = Primitive.intObjectMap();
        }
        this.createdPropertyKeyTokens.put(id, (Object)propertyKeyName);
        this.changed();
    }

    @Override
    public void relationshipTypeDoCreateForName(String labelName, int id) {
        if (this.createdRelationshipTypeTokens == null) {
            this.createdRelationshipTypeTokens = Primitive.intObjectMap();
        }
        this.createdRelationshipTypeTokens.put(id, (Object)labelName);
        this.changed();
    }

    @Override
    public NodeState getNodeState(long id) {
        if (this.nodeStatesMap == null) {
            return NodeStateImpl.EMPTY;
        }
        NodeState nodeState = (NodeState)this.nodeStatesMap.get(id);
        return nodeState == null ? NodeStateImpl.EMPTY : nodeState;
    }

    @Override
    public RelationshipState getRelationshipState(long id) {
        if (this.relationshipStatesMap == null) {
            return RelationshipStateImpl.EMPTY;
        }
        RelationshipStateImpl relationshipState = (RelationshipStateImpl)this.relationshipStatesMap.get(id);
        return relationshipState == null ? RelationshipStateImpl.EMPTY : relationshipState;
    }

    @Override
    public GraphState getGraphState() {
        return this.graphState;
    }

    @Override
    public Cursor<NodeItem> augmentSingleNodeCursor(Cursor<NodeItem> cursor, long nodeId) {
        return this.hasChanges ? this.singleNodeCursor.get().init(cursor, nodeId) : cursor;
    }

    @Override
    public Cursor<PropertyItem> augmentPropertyCursor(Cursor<PropertyItem> cursor, PropertyContainerState propertyContainerState) {
        return propertyContainerState.hasPropertyChanges() ? this.propertyCursor.get().init(cursor, propertyContainerState) : cursor;
    }

    @Override
    public Cursor<PropertyItem> augmentSinglePropertyCursor(Cursor<PropertyItem> cursor, PropertyContainerState propertyContainerState, int propertyKeyId) {
        return propertyContainerState.hasPropertyChanges() ? this.singlePropertyCursor.get().init(cursor, propertyContainerState, propertyKeyId) : cursor;
    }

    @Override
    public PrimitiveIntSet augmentLabels(PrimitiveIntSet labels, NodeState nodeState) {
        ReadableDiffSets<Integer> labelDiffSets = nodeState.labelDiffSets();
        if (!labelDiffSets.isEmpty()) {
            labelDiffSets.getRemoved().forEach(arg_0 -> ((PrimitiveIntSet)labels).remove(arg_0));
            labelDiffSets.getAdded().forEach(arg_0 -> ((PrimitiveIntSet)labels).add(arg_0));
        }
        return labels;
    }

    @Override
    public Cursor<RelationshipItem> augmentSingleRelationshipCursor(Cursor<RelationshipItem> cursor, long relationshipId) {
        return this.hasChanges ? this.singleRelationshipCursor.get().init(cursor, relationshipId) : cursor;
    }

    @Override
    public Cursor<RelationshipItem> augmentNodeRelationshipCursor(Cursor<RelationshipItem> cursor, NodeState nodeState, Direction direction) {
        return nodeState.hasRelationshipChanges() ? this.iteratorRelationshipCursor.get().init(cursor, nodeState.getAddedRelationships(direction)) : cursor;
    }

    @Override
    public Cursor<RelationshipItem> augmentNodeRelationshipCursor(Cursor<RelationshipItem> cursor, NodeState nodeState, Direction direction, int[] relTypes) {
        return nodeState.hasRelationshipChanges() ? this.iteratorRelationshipCursor.get().init(cursor, nodeState.getAddedRelationships(direction, relTypes)) : cursor;
    }

    @Override
    public Cursor<RelationshipItem> augmentRelationshipsGetAllCursor(Cursor<RelationshipItem> cursor) {
        return this.hasChanges && this.relationships != null && !this.relationships.isEmpty() ? this.iteratorRelationshipCursor.get().init(cursor, PrimitiveLongCollections.toPrimitiveIterator(this.relationships.getAdded().iterator())) : cursor;
    }

    @Override
    public ReadableDiffSets<Long> nodesWithLabelChanged(int label) {
        return this.getLabelStateNodeDiffSets(label);
    }

    @Override
    public ReadableDiffSets<Long> nodesWithAnyOfLabelsChanged(int ... labels) {
        HashSet added = new HashSet();
        HashSet removed = new HashSet();
        for (int i = 0; i < labels.length; ++i) {
            ReadableDiffSets<Long> nodeDiffSets = this.getLabelStateNodeDiffSets(labels[i]);
            if (i == 0) {
                removed.addAll(nodeDiffSets.getRemoved());
            } else {
                removed.retainAll(nodeDiffSets.getRemoved());
            }
            added.addAll(nodeDiffSets.getAdded());
        }
        return new DiffSets<Long>(added, removed);
    }

    @Override
    public ReadableDiffSets<Long> nodesWithAllLabelsChanged(int ... labels) {
        DiffSets<Long> changes = new DiffSets<Long>();
        for (int label : labels) {
            ReadableDiffSets<Long> nodeDiffSets = this.getLabelStateNodeDiffSets(label);
            changes.addAll(nodeDiffSets.getAdded().iterator());
            changes.removeAll(nodeDiffSets.getRemoved().iterator());
        }
        return changes;
    }

    @Override
    public void indexRuleDoAdd(IndexDescriptor descriptor) {
        DiffSets<IndexDescriptor> diff = this.indexChangesDiffSets();
        if (!diff.unRemove((Object)descriptor)) {
            diff.add((Object)descriptor);
        }
        this.changed();
    }

    @Override
    public void indexDoDrop(IndexDescriptor descriptor) {
        this.indexChangesDiffSets().remove((Object)descriptor);
        this.changed();
    }

    @Override
    public boolean indexDoUnRemove(IndexDescriptor descriptor) {
        return this.indexChangesDiffSets().unRemove((Object)descriptor);
    }

    @Override
    public ReadableDiffSets<IndexDescriptor> indexDiffSetsByLabel(int labelId) {
        return this.indexChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasLabel((int)labelId));
    }

    @Override
    public ReadableDiffSets<IndexDescriptor> indexChanges() {
        return ReadableDiffSets.Empty.ifNull(this.indexChanges);
    }

    private DiffSets<IndexDescriptor> indexChangesDiffSets() {
        if (this.indexChanges == null) {
            this.indexChanges = new DiffSets();
        }
        return this.indexChanges;
    }

    @Override
    public ReadableDiffSets<Long> addedAndRemovedNodes() {
        return ReadableDiffSets.Empty.ifNull(this.nodes);
    }

    private RemovalsCountingDiffSets nodes() {
        if (this.nodes == null) {
            this.nodes = new RemovalsCountingDiffSets();
        }
        return this.nodes;
    }

    @Override
    public int augmentNodeDegree(long nodeId, int degree, Direction direction) {
        return this.getNodeState(nodeId).augmentDegree(direction, degree);
    }

    @Override
    public int augmentNodeDegree(long nodeId, int degree, Direction direction, int typeId) {
        return this.getNodeState(nodeId).augmentDegree(direction, degree, typeId);
    }

    @Override
    public PrimitiveIntSet nodeRelationshipTypes(long nodeId) {
        return this.getNodeState(nodeId).relationshipTypes();
    }

    @Override
    public ReadableRelationshipDiffSets<Long> addedAndRemovedRelationships() {
        return ReadableRelationshipDiffSets.Empty.ifNull(this.relationships);
    }

    private RemovalsCountingRelationshipsDiffSets relationships() {
        if (this.relationships == null) {
            this.relationships = new RemovalsCountingRelationshipsDiffSets(this);
        }
        return this.relationships;
    }

    @Override
    public Iterable<RelationshipState> modifiedRelationships() {
        return this.relationshipStatesMap == null ? Iterables.empty() : Iterables.cast((Iterable)this.relationshipStatesMap.values());
    }

    private NodeStateImpl getOrCreateNodeState(long nodeId) {
        if (this.nodeStatesMap == null) {
            this.nodeStatesMap = Primitive.longObjectMap();
        }
        return (NodeStateImpl)this.nodeStatesMap.computeIfAbsent(nodeId, unused -> new NodeStateImpl(nodeId, this));
    }

    private RelationshipStateImpl getOrCreateRelationshipState(long relationshipId) {
        if (this.relationshipStatesMap == null) {
            this.relationshipStatesMap = Primitive.longObjectMap();
        }
        return (RelationshipStateImpl)this.relationshipStatesMap.computeIfAbsent(relationshipId, unused -> new RelationshipStateImpl(relationshipId));
    }

    private GraphState getOrCreateGraphState() {
        if (this.graphState == null) {
            this.graphState = new GraphState();
        }
        return this.graphState;
    }

    @Override
    public void constraintDoAdd(IndexBackedConstraintDescriptor constraint, long indexId) {
        this.constraintsChangesDiffSets().add((Object)constraint);
        this.createdConstraintIndexesByConstraint().put(constraint, indexId);
        this.changed();
    }

    @Override
    public void constraintDoAdd(ConstraintDescriptor constraint) {
        this.constraintsChangesDiffSets().add((Object)constraint);
        this.changed();
    }

    @Override
    public ReadableDiffSets<ConstraintDescriptor> constraintsChangesForLabel(int labelId) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasLabel((int)labelId));
    }

    @Override
    public ReadableDiffSets<ConstraintDescriptor> constraintsChangesForSchema(SchemaDescriptor descriptor) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptor.equalTo((SchemaDescriptor)descriptor));
    }

    @Override
    public ReadableDiffSets<ConstraintDescriptor> constraintsChangesForRelationshipType(int relTypeId) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasRelType((int)relTypeId));
    }

    @Override
    public ReadableDiffSets<ConstraintDescriptor> constraintsChanges() {
        return ReadableDiffSets.Empty.ifNull(this.constraintsChanges);
    }

    private DiffSets<ConstraintDescriptor> constraintsChangesDiffSets() {
        if (this.constraintsChanges == null) {
            this.constraintsChanges = new DiffSets();
        }
        return this.constraintsChanges;
    }

    @Override
    public void constraintDoDrop(ConstraintDescriptor constraint) {
        this.constraintsChangesDiffSets().remove((Object)constraint);
        if (constraint.enforcesUniqueness()) {
            this.indexDoDrop(this.getIndexForIndexBackedConstraint((IndexBackedConstraintDescriptor)constraint));
        }
        this.changed();
    }

    @Override
    public boolean constraintDoUnRemove(ConstraintDescriptor constraint) {
        return this.constraintsChangesDiffSets().unRemove((Object)constraint);
    }

    @Override
    public Iterable<IndexDescriptor> constraintIndexesCreatedInTx() {
        if (this.createdConstraintIndexesByConstraint != null && !this.createdConstraintIndexesByConstraint.isEmpty()) {
            return Iterables.map(this::getIndexForIndexBackedConstraint, this.createdConstraintIndexesByConstraint.keySet());
        }
        return Iterables.empty();
    }

    @Override
    public Long indexCreatedForConstraint(ConstraintDescriptor constraint) {
        return this.createdConstraintIndexesByConstraint == null ? null : this.createdConstraintIndexesByConstraint.get(constraint);
    }

    @Override
    public PrimitiveLongReadableDiffSets indexUpdatesForScan(IndexDescriptor descriptor) {
        if (this.indexUpdates == null) {
            return EmptyPrimitiveLongReadableDiffSets.INSTANCE;
        }
        Map<ValueTuple, PrimitiveLongDiffSets> updates = this.indexUpdates.get(descriptor.schema());
        if (updates == null) {
            return EmptyPrimitiveLongReadableDiffSets.INSTANCE;
        }
        PrimitiveLongDiffSets diffs = new PrimitiveLongDiffSets();
        for (PrimitiveLongDiffSets diffSet : updates.values()) {
            diffs.addAll(diffSet.getAdded().iterator());
            diffs.removeAll(diffSet.getRemoved().iterator());
        }
        return diffs;
    }

    @Override
    public PrimitiveLongReadableDiffSets indexUpdatesForSeek(IndexDescriptor descriptor, ValueTuple values) {
        PrimitiveLongDiffSets indexUpdatesForSeek = this.getIndexUpdatesForSeek(descriptor.schema(), values, false);
        return indexUpdatesForSeek == null ? EmptyPrimitiveLongReadableDiffSets.INSTANCE : indexUpdatesForSeek;
    }

    @Override
    public PrimitiveLongReadableDiffSets indexUpdatesForRangeSeekByNumber(IndexDescriptor descriptor, Number lower, boolean includeLower, Number upper, boolean includeUpper) {
        boolean selectedIncludeUpper;
        ValueTuple selectedUpper;
        boolean selectedIncludeLower;
        ValueTuple selectedLower;
        TreeMap<ValueTuple, PrimitiveLongDiffSets> sortedUpdates = this.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return EmptyPrimitiveLongReadableDiffSets.INSTANCE;
        }
        if (lower == null) {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.MIN_NUMBER});
            selectedIncludeLower = true;
        } else {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.numberValue((Number)lower)});
            selectedIncludeLower = includeLower;
        }
        if (upper == null) {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.MAX_NUMBER});
            selectedIncludeUpper = true;
        } else {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.numberValue((Number)upper)});
            selectedIncludeUpper = includeUpper;
        }
        return this.indexUpdatesForRangeSeek(sortedUpdates, selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper);
    }

    @Override
    public PrimitiveLongReadableDiffSets indexUpdatesForRangeSeekByGeometry(IndexDescriptor descriptor, PointValue lower, boolean includeLower, PointValue upper, boolean includeUpper) {
        boolean selectedIncludeUpper;
        ValueTuple selectedUpper;
        boolean selectedIncludeLower;
        ValueTuple selectedLower;
        TreeMap<ValueTuple, PrimitiveLongDiffSets> sortedUpdates = this.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return EmptyPrimitiveLongReadableDiffSets.INSTANCE;
        }
        if (lower == null && upper == null) {
            throw new IllegalArgumentException("Cannot access TxState with invalid GeometryRangePredicate");
        }
        if (lower == null) {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.minPointValue((PointValue)upper)});
            selectedIncludeLower = true;
        } else {
            selectedLower = ValueTuple.of((Value[])new Value[]{lower});
            selectedIncludeLower = includeLower;
        }
        if (upper == null) {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.maxPointValue((PointValue)lower)});
            selectedIncludeUpper = true;
        } else {
            selectedUpper = ValueTuple.of((Value[])new Value[]{upper});
            selectedIncludeUpper = includeUpper;
        }
        return this.indexUpdatesForRangeSeek(sortedUpdates, selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper);
    }

    @Override
    public PrimitiveLongReadableDiffSets indexUpdatesForRangeSeekByString(IndexDescriptor descriptor, String lower, boolean includeLower, String upper, boolean includeUpper) {
        boolean selectedIncludeUpper;
        ValueTuple selectedUpper;
        boolean selectedIncludeLower;
        ValueTuple selectedLower;
        TreeMap<ValueTuple, PrimitiveLongDiffSets> sortedUpdates = this.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return EmptyPrimitiveLongReadableDiffSets.INSTANCE;
        }
        if (lower == null) {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.MIN_STRING});
            selectedIncludeLower = true;
        } else {
            selectedLower = ValueTuple.of((Value[])new Value[]{Values.stringValue((String)lower)});
            selectedIncludeLower = includeLower;
        }
        if (upper == null) {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.MAX_STRING});
            selectedIncludeUpper = false;
        } else {
            selectedUpper = ValueTuple.of((Value[])new Value[]{Values.stringValue((String)upper)});
            selectedIncludeUpper = includeUpper;
        }
        return this.indexUpdatesForRangeSeek(sortedUpdates, selectedLower, selectedIncludeLower, selectedUpper, selectedIncludeUpper);
    }

    private PrimitiveLongReadableDiffSets indexUpdatesForRangeSeek(TreeMap<ValueTuple, PrimitiveLongDiffSets> sortedUpdates, ValueTuple lower, boolean includeLower, ValueTuple upper, boolean includeUpper) {
        PrimitiveLongDiffSets diffs = new PrimitiveLongDiffSets();
        Collection inRange = sortedUpdates.subMap(lower, includeLower, upper, includeUpper).values();
        for (PrimitiveLongDiffSets diffForSpecificValue : inRange) {
            diffs.addAll(diffForSpecificValue.getAdded().iterator());
            diffs.removeAll(diffForSpecificValue.getRemoved().iterator());
        }
        return diffs;
    }

    @Override
    public PrimitiveLongReadableDiffSets indexUpdatesForRangeSeekByPrefix(IndexDescriptor descriptor, String prefix) {
        Map.Entry<ValueTuple, PrimitiveLongDiffSets> entry;
        ValueTuple key;
        TreeMap<ValueTuple, PrimitiveLongDiffSets> sortedUpdates = this.getSortedIndexUpdates(descriptor.schema());
        if (sortedUpdates == null) {
            return EmptyPrimitiveLongReadableDiffSets.INSTANCE;
        }
        ValueTuple floor = ValueTuple.of((Value[])new Value[]{Values.stringValue((String)prefix)});
        PrimitiveLongDiffSets diffs = new PrimitiveLongDiffSets();
        Iterator<Map.Entry<ValueTuple, PrimitiveLongDiffSets>> iterator = sortedUpdates.tailMap(floor).entrySet().iterator();
        while (iterator.hasNext() && ((TextValue)(key = (entry = iterator.next()).getKey()).getOnlyValue()).stringValue().startsWith(prefix)) {
            PrimitiveLongDiffSets diffSets = entry.getValue();
            diffs.addAll(diffSets.getAdded().iterator());
            diffs.removeAll(diffSets.getRemoved().iterator());
        }
        return diffs;
    }

    private TreeMap<ValueTuple, PrimitiveLongDiffSets> getSortedIndexUpdates(LabelSchemaDescriptor descriptor) {
        TreeMap<ValueTuple, PrimitiveLongDiffSets> sortedUpdates;
        if (this.indexUpdates == null) {
            return null;
        }
        Map<ValueTuple, PrimitiveLongDiffSets> updates = this.indexUpdates.get(descriptor);
        if (updates == null) {
            return null;
        }
        if (updates instanceof TreeMap) {
            sortedUpdates = (TreeMap<ValueTuple, PrimitiveLongDiffSets>)updates;
        } else {
            sortedUpdates = new TreeMap<ValueTuple, PrimitiveLongDiffSets>(ValueTuple.COMPARATOR);
            sortedUpdates.putAll(updates);
            this.indexUpdates.put(descriptor, sortedUpdates);
        }
        return sortedUpdates;
    }

    @Override
    public void indexDoUpdateEntry(LabelSchemaDescriptor descriptor, long nodeId, ValueTuple propertiesBefore, ValueTuple propertiesAfter) {
        NodeStateImpl nodeState = this.getOrCreateNodeState(nodeId);
        Map<ValueTuple, PrimitiveLongDiffSets> updates = this.getIndexUpdatesByDescriptor(descriptor, true);
        if (propertiesBefore != null) {
            PrimitiveLongDiffSets before = this.getIndexUpdatesForSeek(updates, propertiesBefore, true);
            before.remove(nodeId);
            if (before.getRemoved().contains(nodeId)) {
                nodeState.addIndexDiff(before);
            } else {
                nodeState.removeIndexDiff(before);
            }
        }
        if (propertiesAfter != null) {
            PrimitiveLongDiffSets after = this.getIndexUpdatesForSeek(updates, propertiesAfter, true);
            after.add(nodeId);
            if (after.getAdded().contains(nodeId)) {
                nodeState.addIndexDiff(after);
            } else {
                nodeState.removeIndexDiff(after);
            }
        }
    }

    private PrimitiveLongDiffSets getIndexUpdatesForSeek(LabelSchemaDescriptor schema, ValueTuple values, boolean create) {
        Map<ValueTuple, PrimitiveLongDiffSets> updates = this.getIndexUpdatesByDescriptor(schema, create);
        if (updates != null) {
            return this.getIndexUpdatesForSeek(updates, values, create);
        }
        return null;
    }

    private PrimitiveLongDiffSets getIndexUpdatesForSeek(Map<ValueTuple, PrimitiveLongDiffSets> updates, ValueTuple values, boolean create) {
        return create ? updates.computeIfAbsent(values, value -> new PrimitiveLongDiffSets()) : updates.get(values);
    }

    private Map<ValueTuple, PrimitiveLongDiffSets> getIndexUpdatesByDescriptor(LabelSchemaDescriptor schema, boolean create) {
        Map<ValueTuple, PrimitiveLongDiffSets> updates;
        if (this.indexUpdates == null) {
            if (!create) {
                return null;
            }
            this.indexUpdates = new HashMap<LabelSchemaDescriptor, Map<ValueTuple, PrimitiveLongDiffSets>>();
        }
        if ((updates = this.indexUpdates.get(schema)) == null) {
            if (!create) {
                return null;
            }
            updates = new HashMap<ValueTuple, PrimitiveLongDiffSets>();
            this.indexUpdates.put(schema, updates);
        }
        return updates;
    }

    private Map<IndexBackedConstraintDescriptor, Long> createdConstraintIndexesByConstraint() {
        if (this.createdConstraintIndexesByConstraint == null) {
            this.createdConstraintIndexesByConstraint = new HashMap<IndexBackedConstraintDescriptor, Long>();
        }
        return this.createdConstraintIndexesByConstraint;
    }

    private IndexDescriptor getIndexForIndexBackedConstraint(IndexBackedConstraintDescriptor constraint) {
        return constraint.ownedIndexDescriptor();
    }

    private boolean hasNodeState(long nodeId) {
        return this.nodeStatesMap != null && this.nodeStatesMap.containsKey(nodeId);
    }

    private PropertyChanges nodePropertyChanges() {
        return this.propertyChangesForNodes == null ? (this.propertyChangesForNodes = new PropertyChanges()) : this.propertyChangesForNodes;
    }

    @Override
    public PrimitiveLongResourceIterator augmentNodesGetAll(PrimitiveLongIterator committed) {
        return (PrimitiveLongResourceIterator)this.addedAndRemovedNodes().augment(committed);
    }

    @Override
    public RelationshipIterator augmentRelationshipsGetAll(RelationshipIterator committed) {
        return (RelationshipIterator)this.addedAndRemovedRelationships().augment(committed);
    }

    @Override
    public <EX extends Exception> boolean relationshipVisit(long relId, RelationshipVisitor<EX> visitor) throws EX {
        return this.getRelationshipState(relId).accept(visitor);
    }

    @Override
    public boolean hasDataChanges() {
        return this.hasDataChanges;
    }

    private static class RemovalsCountingRelationshipsDiffSets
    extends RelationshipDiffSets<Long> {
        private PrimitiveLongSet removedFromAdded;

        private RemovalsCountingRelationshipsDiffSets(RelationshipVisitor.Home txStateRelationshipHome) {
            super(txStateRelationshipHome);
        }

        @Override
        public boolean remove(Long elem) {
            if (this.added(false).remove(elem)) {
                if (this.removedFromAdded == null) {
                    this.removedFromAdded = Primitive.longSet();
                }
                this.removedFromAdded.add(elem.longValue());
                return true;
            }
            return this.removed(true).add(elem);
        }

        private boolean wasRemoved(long id) {
            return this.removedFromAdded != null && this.removedFromAdded.contains(id) || super.isRemoved((Object)id);
        }
    }

    private static class RemovalsCountingDiffSets
    extends DiffSets<Long> {
        private PrimitiveLongSet removedFromAdded;

        private RemovalsCountingDiffSets() {
        }

        @Override
        public boolean remove(Long elem) {
            if (this.added(false).remove(elem)) {
                if (this.removedFromAdded == null) {
                    this.removedFromAdded = Primitive.longSet();
                }
                this.removedFromAdded.add(elem.longValue());
                return true;
            }
            return this.removed(true).add(elem);
        }

        private boolean wasRemoved(long id) {
            return this.removedFromAdded != null && this.removedFromAdded.contains(id) || super.isRemoved((Object)id);
        }
    }

    private static class ConstraintDiffSetsVisitor
    implements DiffSetsVisitor<ConstraintDescriptor> {
        private final TxStateVisitor visitor;

        ConstraintDiffSetsVisitor(TxStateVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public void visitAdded(ConstraintDescriptor constraint) throws CreateConstraintFailureException {
            this.visitor.visitAddedConstraint(constraint);
        }

        @Override
        public void visitRemoved(ConstraintDescriptor constraint) {
            this.visitor.visitRemovedConstraint(constraint);
        }
    }

    private static class RelationshipTypeTokenStateVisitor
    implements PrimitiveIntObjectVisitor<String, RuntimeException> {
        private final TxStateVisitor visitor;

        RelationshipTypeTokenStateVisitor(TxStateVisitor visitor) {
            this.visitor = visitor;
        }

        public boolean visited(int key, String value) {
            this.visitor.visitCreatedRelationshipTypeToken(value, key);
            return false;
        }
    }

    private static class PropertyKeyTokenStateVisitor
    implements PrimitiveIntObjectVisitor<String, RuntimeException> {
        private final TxStateVisitor visitor;

        PropertyKeyTokenStateVisitor(TxStateVisitor visitor) {
            this.visitor = visitor;
        }

        public boolean visited(int key, String value) {
            this.visitor.visitCreatedPropertyKeyToken(value, key);
            return false;
        }
    }

    private static class LabelTokenStateVisitor
    implements PrimitiveIntObjectVisitor<String, RuntimeException> {
        private final TxStateVisitor visitor;

        LabelTokenStateVisitor(TxStateVisitor visitor) {
            this.visitor = visitor;
        }

        public boolean visited(int key, String value) {
            this.visitor.visitCreatedLabelToken(value, key);
            return false;
        }
    }
}

