/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.helpers.MathUtil;
import org.neo4j.helpers.Strings;
import org.neo4j.kernel.impl.api.PropertyValueComparator;
import org.neo4j.values.storable.PointValue;

public class PropertyValueComparison {
    public static final PropertyValueComparator<Object> COMPARE_VALUES = new AnyPropertyValueComparator();
    public static final PropertyValueComparator<Number> COMPARE_NUMBERS = new NumberPropertyValueComparator();
    public static final PropertyValueComparator<Object> COMPARE_STRINGS = new StringPropertyValueComparator();
    public static final PropertyValueComparator<PointValue> COMPARE_POINTS = new PointPropertyValueComparator();
    public static final PropertyValueComparator<SuperType> COMPARE_SUPER_TYPE = new PropertyValueSuperTypeComparator();

    private PropertyValueComparison() {
        throw new AssertionError((Object)"no instance");
    }

    private static class StringPropertyValueComparator
    extends PropertyValueComparator<Object> {
        private StringPropertyValueComparator() {
        }

        @Override
        public int compare(Object left, Object right) {
            return this.convert(left).compareTo(this.convert(right));
        }

        private String convert(Object value) {
            Class<?> clazz = value.getClass();
            if (clazz.equals(String.class) || clazz.equals(Character.class)) {
                return value.toString();
            }
            throw new IllegalArgumentException(String.format("Cannot compare %s as a string", value));
        }
    }

    private static class PointPropertyValueComparator
    extends PropertyValueComparator<PointValue> {
        private PointPropertyValueComparator() {
        }

        @Override
        public int compare(PointValue left, PointValue right) {
            return left.compareTo(right);
        }
    }

    private static class NumberPropertyValueComparator
    extends PropertyValueComparator<Number> {
        private NumberPropertyValueComparator() {
        }

        @Override
        public int compare(Number left, Number right) {
            Class<?> rightClazz;
            Class<?> leftClazz = left.getClass();
            if (leftClazz == (rightClazz = right.getClass())) {
                return ((Comparable)((Object)left)).compareTo(right);
            }
            if (left instanceof Double || left instanceof Float) {
                double lhs = left.doubleValue();
                if (right instanceof Long) {
                    long rhs = right.longValue();
                    return MathUtil.compareDoubleAgainstLong((double)lhs, (long)rhs);
                }
                return Double.compare(lhs, right.doubleValue());
            }
            if (right instanceof Double || right instanceof Float) {
                double rhs = right.doubleValue();
                if (left instanceof Long) {
                    long lhs = left.longValue();
                    return MathUtil.compareLongAgainstDouble((long)lhs, (double)rhs);
                }
                return Double.compare(left.doubleValue(), rhs);
            }
            if (leftClazz.equals(Long.class)) {
                if (rightClazz.equals(Integer.class) || rightClazz.equals(Short.class) || rightClazz.equals(Byte.class)) {
                    return Long.compare(left.longValue(), right.longValue());
                }
            } else if (leftClazz.equals(Integer.class)) {
                if (rightClazz.equals(Long.class)) {
                    return Long.compare(left.longValue(), right.longValue());
                }
                if (rightClazz.equals(Short.class) || rightClazz.equals(Byte.class)) {
                    return Integer.compare(left.intValue(), right.intValue());
                }
            } else if (leftClazz.equals(Short.class)) {
                if (rightClazz.equals(Long.class)) {
                    return Long.compare(left.longValue(), right.longValue());
                }
                if (rightClazz.equals(Integer.class)) {
                    return Integer.compare(left.intValue(), right.intValue());
                }
                if (rightClazz.equals(Byte.class)) {
                    return Short.compare(left.shortValue(), right.shortValue());
                }
            } else if (leftClazz.equals(Byte.class)) {
                if (rightClazz.equals(Long.class)) {
                    return Long.compare(left.longValue(), right.longValue());
                }
                if (rightClazz.equals(Integer.class)) {
                    return Integer.compare(left.intValue(), right.intValue());
                }
                if (rightClazz.equals(Short.class)) {
                    return Short.compare(left.shortValue(), right.shortValue());
                }
            }
            throw new IllegalArgumentException(String.format("Comparing numbers %s and %s (with type %s and %s) is not supported", left, right, leftClazz, rightClazz));
        }
    }

    private static class PropertyValueSuperTypeComparator
    extends PropertyValueComparator<SuperType> {
        private PropertyValueSuperTypeComparator() {
        }

        @Override
        public int compare(SuperType left, SuperType right) {
            return Integer.compare(left.typeId, right.typeId);
        }
    }

    private static class AnyPropertyValueComparator
    extends PropertyValueComparator<Object> {
        private AnyPropertyValueComparator() {
        }

        @Override
        public int compare(Object left, Object right) {
            SuperType rightType;
            SuperType leftType = SuperType.ofValue(left);
            int cmp = COMPARE_SUPER_TYPE.compare(leftType, rightType = SuperType.ofValue(right));
            if (cmp == 0) {
                switch (leftType) {
                    case NUMBER: {
                        return COMPARE_NUMBERS.compare((Number)left, (Number)right);
                    }
                    case STRING: {
                        return left.toString().compareTo(right.toString());
                    }
                    case BOOLEAN: {
                        return Boolean.compare((Boolean)left, (Boolean)right);
                    }
                    case GEOMETRY: {
                        return COMPARE_POINTS.compare((PointValue)left, (PointValue)right);
                    }
                }
                String leftString = Strings.prettyPrint(left);
                String rightString = Strings.prettyPrint(right);
                return leftString.compareTo(rightString);
            }
            return cmp;
        }
    }

    public static enum SuperType {
        OTHER(0),
        STRING(1),
        BOOLEAN(2),
        GEOMETRY(3),
        NUMBER(4);

        public final int typeId;

        private SuperType(int typeId) {
            this.typeId = typeId;
        }

        public boolean isSuperTypeOf(Object value) {
            return this == SuperType.ofValue(value);
        }

        public static SuperType ofValue(Object value) {
            if (null == value) {
                throw new NullPointerException("null is not a valid property value and hence has no PropertyValueComparison.SuperType");
            }
            if (value instanceof String) {
                return STRING;
            }
            if (value instanceof Number) {
                return NUMBER;
            }
            if (value instanceof Boolean) {
                return BOOLEAN;
            }
            if (value instanceof Character) {
                return STRING;
            }
            if (value instanceof PointValue) {
                return GEOMETRY;
            }
            return OTHER;
        }
    }
}

