/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration.ssl;

import io.netty.handler.ssl.SslProvider;
import java.util.Arrays;
import java.util.List;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Settings;

@Description(value="System-wide settings for SSL.")
public class SslSystemSettings
implements LoadableConfig {
    static final String TLS_PROTOCOL_DEFAULT_KEY = "org.neo4j.tls.protocol.default";
    private static final String TLS_DEFAULT = "TLSv1.2";
    @Description(value="Netty SSL provider")
    public static final Setting<SslProvider> netty_ssl_provider = Settings.setting("dbms.netty.ssl.provider", Settings.options(SslProvider.class), SslProvider.JDK.name());

    static List<String> getTlsDefault() {
        String protocolProperty = System.getProperty(TLS_PROTOCOL_DEFAULT_KEY, TLS_DEFAULT).trim();
        return Arrays.asList(protocolProperty.split("\\s*,\\s*"));
    }
}

