/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.constaints;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptorFactory;

public abstract class IndexBackedConstraintDescriptor
extends ConstraintDescriptor
implements LabelSchemaSupplier {
    private final LabelSchemaDescriptor schema;

    IndexBackedConstraintDescriptor(ConstraintDescriptor.Type type, LabelSchemaDescriptor schema) {
        super(type);
        this.schema = schema;
    }

    public LabelSchemaDescriptor schema() {
        return this.schema;
    }

    public IndexDescriptor ownedIndexDescriptor() {
        return IndexDescriptorFactory.uniqueForSchema(this.schema);
    }

    public String prettyPrint(TokenNameLookup tokenNameLookup) {
        String labelName = this.escapeLabelOrRelTyp(tokenNameLookup.labelGetName(this.schema.getLabelId()));
        String nodeName = labelName.toLowerCase();
        String properties = SchemaUtil.niceProperties((TokenNameLookup)tokenNameLookup, (int[])this.schema.getPropertyIds(), (String)(nodeName + "."), (this.schema().getPropertyIds().length > 1 ? 1 : 0) != 0);
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT %s IS %s", nodeName, labelName, properties, this.constraintTypeText());
    }

    protected abstract String constraintTypeText();
}

