/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.Closeable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.ToIntFunction;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.kernel.impl.transaction.state.TokenCreator;
import org.neo4j.storageengine.api.Token;
import org.neo4j.unsafe.batchinsert.internal.DirectRecordAccess;

public abstract class BatchingTokenRepository<RECORD extends TokenRecord, TOKEN extends Token>
implements ToIntFunction<Object>,
Closeable {
    private final Map<String, Integer> tokens = new HashMap<String, Integer>();
    private final TokenStore<RECORD, TOKEN> store;
    private final RecordAccess.Loader<RECORD, Void> loader;
    private int highId;
    private int highestCreatedId;

    public BatchingTokenRepository(TokenStore<RECORD, TOKEN> store, RecordAccess.Loader<RECORD, Void> loader) {
        this.store = store;
        this.loader = loader;
        this.highId = (int)store.getHighId();
        this.highestCreatedId = this.highId - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrCreateId(String name) {
        assert (name != null);
        Integer id = this.tokens.get(name);
        if (id == null) {
            Map<String, Integer> map = this.tokens;
            synchronized (map) {
                id = this.tokens.get(name);
                if (id == null) {
                    id = this.highId++;
                    this.tokens.put(name, id);
                }
            }
        }
        return id;
    }

    public int getOrCreateId(Object key) {
        if (key instanceof String) {
            return this.getOrCreateId((String)key);
        }
        if (key instanceof Integer) {
            return (Integer)key;
        }
        throw new IllegalArgumentException("Expected either a String or Integer for property key, but was '" + key + "', " + key.getClass());
    }

    @Override
    public int applyAsInt(Object key) {
        return this.getOrCreateId(key);
    }

    public long[] getOrCreateIds(String[] names) {
        return this.getOrCreateIds(names, names.length);
    }

    public long[] getOrCreateIds(String[] names, int length) {
        int from;
        long[] result = new long[length];
        int to = 0;
        for (from = 0; from < length; ++from) {
            int id = this.getOrCreateId(names[from]);
            if (this.contains(result, id, to)) continue;
            result[to++] = id;
        }
        if (to < from) {
            result = Arrays.copyOf(result, to);
        }
        Arrays.sort(result);
        return result;
    }

    private boolean contains(long[] array, long id, int arrayLength) {
        for (int i = 0; i < arrayLength; ++i) {
            if (array[i] != id) continue;
            return true;
        }
        return false;
    }

    public int getHighId() {
        return this.highId;
    }

    @Override
    public void close() {
        this.flush();
    }

    public void flush() {
        DirectRecordAccess<RECORD, Void> recordAccess = new DirectRecordAccess<RECORD, Void>(this.store, this.loader);
        TokenCreator<RECORD, TOKEN> creator = new TokenCreator<RECORD, TOKEN>(this.store);
        int highest = this.highestCreatedId;
        for (Map.Entry<Integer, String> tokenToCreate : this.sortCreatedTokensById()) {
            if (tokenToCreate.getKey() <= this.highestCreatedId) continue;
            creator.createToken(tokenToCreate.getValue(), tokenToCreate.getKey(), recordAccess);
            highest = Math.max(highest, tokenToCreate.getKey());
        }
        int highestId = Math.max(Math.toIntExact(this.store.getHighestPossibleIdInUse()), highest);
        recordAccess.close();
        this.store.setHighestPossibleIdInUse(highestId);
        this.highestCreatedId = highestId;
    }

    private Iterable<Map.Entry<Integer, String>> sortCreatedTokensById() {
        TreeMap<Integer, String> sorted = new TreeMap<Integer, String>();
        for (Map.Entry<String, Integer> entry : this.tokens.entrySet()) {
            sorted.put(entry.getValue(), entry.getKey());
        }
        return sorted.entrySet();
    }

    public static class BatchingRelationshipTypeTokenRepository
    extends BatchingTokenRepository<RelationshipTypeTokenRecord, RelationshipTypeToken> {
        public BatchingRelationshipTypeTokenRepository(TokenStore<RelationshipTypeTokenRecord, RelationshipTypeToken> store) {
            super(store, Loaders.relationshipTypeTokenLoader(store));
        }
    }

    public static class BatchingLabelTokenRepository
    extends BatchingTokenRepository<LabelTokenRecord, Token> {
        public BatchingLabelTokenRepository(TokenStore<LabelTokenRecord, Token> store) {
            super(store, Loaders.labelTokenLoader(store));
        }
    }

    public static class BatchingPropertyKeyTokenRepository
    extends BatchingTokenRepository<PropertyKeyTokenRecord, Token> {
        public BatchingPropertyKeyTokenRepository(TokenStore<PropertyKeyTokenRecord, Token> store) {
            super(store, Loaders.propertyKeyTokenLoader(store));
        }
    }
}

