/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputCacher;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputNodeCacheReader;
import org.neo4j.unsafe.impl.batchimport.input.InputNodeCacheWriter;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationshipCacheReader;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationshipCacheWriter;

public class InputCache
implements Closeable {
    private static final String HEADER = "-header";
    private static final String NODES = "nodes";
    private static final String RELATIONSHIPS = "relationships";
    private static final String NODES_HEADER = "nodes-header";
    private static final String RELATIONSHIPS_HEADER = "relationships-header";
    static final byte SAME_GROUP = 0;
    static final byte NEW_GROUP = 1;
    static final byte PROPERTY_KEY_TOKEN = 0;
    static final byte LABEL_TOKEN = 1;
    static final byte RELATIONSHIP_TYPE_TOKEN = 2;
    static final byte GROUP_TOKEN = 3;
    static final byte HIGH_TOKEN_TYPE = 4;
    static final short HAS_FIRST_PROPERTY_ID = -1;
    static final byte HAS_LABEL_FIELD = 3;
    static final byte LABEL_REMOVAL = 1;
    static final byte LABEL_ADDITION = 2;
    static final byte END_OF_LABEL_CHANGES = 0;
    static final byte HAS_TYPE_ID = 2;
    static final byte SAME_TYPE = 0;
    static final byte NEW_TYPE = 1;
    static final byte END_OF_HEADER = -2;
    static final short END_OF_ENTITIES = -3;
    private final FileSystemAbstraction fs;
    private final File cacheDirectory;
    private final RecordFormats recordFormats;
    private final int chunkSize;

    public InputCache(FileSystemAbstraction fs, File cacheDirectory, RecordFormats recordFormats, int chunkSize) {
        this.fs = fs;
        this.cacheDirectory = cacheDirectory;
        this.recordFormats = recordFormats;
        this.chunkSize = chunkSize;
    }

    public InputCacher cacheNodes() throws IOException {
        return new InputNodeCacheWriter(this.channel(NODES, OpenMode.READ_WRITE), this.channel(NODES_HEADER, OpenMode.READ_WRITE), this.recordFormats, this.chunkSize);
    }

    public InputCacher cacheRelationships() throws IOException {
        return new InputRelationshipCacheWriter(this.channel(RELATIONSHIPS, OpenMode.READ_WRITE), this.channel(RELATIONSHIPS_HEADER, OpenMode.READ_WRITE), this.recordFormats, this.chunkSize);
    }

    private StoreChannel channel(String type, OpenMode openMode) throws IOException {
        return this.fs.open(this.file(type), openMode);
    }

    private File file(String type) {
        return new File(this.cacheDirectory, "input-" + type);
    }

    public InputIterable nodes() {
        return this.entities((ThrowingSupplier<InputIterator, IOException>)((ThrowingSupplier)() -> new InputNodeCacheReader(this.channel(NODES, OpenMode.READ), this.channel(NODES_HEADER, OpenMode.READ))));
    }

    public InputIterable relationships() {
        return this.entities((ThrowingSupplier<InputIterator, IOException>)((ThrowingSupplier)() -> new InputRelationshipCacheReader(this.channel(RELATIONSHIPS, OpenMode.READ), this.channel(RELATIONSHIPS_HEADER, OpenMode.READ))));
    }

    private InputIterable entities(final ThrowingSupplier<InputIterator, IOException> factory) {
        return new InputIterable(){

            @Override
            public InputIterator iterator() {
                try {
                    return (InputIterator)factory.get();
                }
                catch (IOException e) {
                    throw new InputException("Unable to open reader for cached entities", e);
                }
            }

            @Override
            public boolean supportsMultiplePasses() {
                return true;
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.fs.deleteFile(this.file(NODES));
        this.fs.deleteFile(this.file(RELATIONSHIPS));
        this.fs.deleteFile(this.file(NODES_HEADER));
        this.fs.deleteFile(this.file(RELATIONSHIPS_HEADER));
    }

    static ByteBuffer newChunkHeaderBuffer() {
        return ByteBuffer.allocate(4);
    }
}

