/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;

public class ByteBufferFlushableChannel
implements FlushableChannel,
Flushable {
    private final ByteBuffer buffer;

    public ByteBufferFlushableChannel(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public Flushable prepareForFlush() throws IOException {
        return this;
    }

    @Override
    public FlushableChannel put(byte value) throws IOException {
        this.buffer.put(value);
        return this;
    }

    @Override
    public FlushableChannel putShort(short value) throws IOException {
        this.buffer.putShort(value);
        return this;
    }

    @Override
    public FlushableChannel putInt(int value) throws IOException {
        this.buffer.putInt(value);
        return this;
    }

    @Override
    public FlushableChannel putLong(long value) throws IOException {
        this.buffer.putLong(value);
        return this;
    }

    @Override
    public FlushableChannel putFloat(float value) throws IOException {
        this.buffer.putFloat(value);
        return this;
    }

    @Override
    public FlushableChannel putDouble(double value) throws IOException {
        this.buffer.putDouble(value);
        return this;
    }

    @Override
    public FlushableChannel put(byte[] value, int length) throws IOException {
        this.buffer.put(value, 0, length);
        return this;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }
}

