/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.concurrent.AsyncEvent;
import org.neo4j.concurrent.AsyncEvents;
import org.neo4j.helpers.Exceptions;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.DuplicateInputIdException;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.InputException;

public class BadCollector
implements Collector {
    public static final int BAD_RELATIONSHIPS = 1;
    public static final int DUPLICATE_NODES = 2;
    public static final int EXTRA_COLUMNS = 4;
    public static final int COLLECT_ALL = 7;
    public static final long UNLIMITED_TOLERANCE = -1L;
    private final PrintStream out;
    private final long tolerance;
    private final int collect;
    private final boolean logBadEntries;
    private final AtomicLong badEntries = new AtomicLong();
    private final AsyncEvents<ProblemReporter> logger;
    private final Thread eventProcessor;

    public BadCollector(OutputStream out, long tolerance, int collect) {
        this(out, tolerance, collect, false);
    }

    public BadCollector(OutputStream out, long tolerance, int collect, boolean skipBadEntriesLogging) {
        this.out = new PrintStream(out);
        this.tolerance = tolerance;
        this.collect = collect;
        this.logBadEntries = !skipBadEntriesLogging;
        this.logger = new AsyncEvents(this::processEvent, AsyncEvents.Monitor.NONE);
        this.eventProcessor = new Thread((Runnable)this.logger);
        this.eventProcessor.start();
    }

    private void processEvent(ProblemReporter report) {
        this.out.println(report.message());
    }

    @Override
    public void collectBadRelationship(Object startId, String startIdGroup, String type, Object endId, String endIdGroup, Object specificValue) {
        this.collect(new RelationshipsProblemReporter(startId, startIdGroup, type, endId, endIdGroup, specificValue));
    }

    @Override
    public void collectExtraColumns(String source, long row, String value) {
        this.collect(new ExtraColumnsProblemReporter(row, source, value));
    }

    @Override
    public void collectDuplicateNode(Object id, long actualId, String group) {
        this.collect(new NodesProblemReporter(id, group));
    }

    @Override
    public boolean isCollectingBadRelationships() {
        return this.collects(1);
    }

    private void collect(ProblemReporter report) {
        boolean collect = this.collects(report.type());
        if (collect) {
            long count = this.badEntries.incrementAndGet();
            if (this.tolerance == -1L || count <= this.tolerance) {
                if (this.logBadEntries) {
                    this.logger.send((AsyncEvent)report);
                }
                return;
            }
        }
        InputException exception = report.exception();
        throw collect ? (InputException)Exceptions.withMessage((Throwable)exception, (String)String.format("Too many bad entries %d, where last one was: %s", this.badEntries.longValue(), exception.getMessage())) : exception;
    }

    @Override
    public void close() {
        this.logger.shutdown();
        try {
            this.logger.awaitTermination();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.out.flush();
        }
    }

    @Override
    public long badEntries() {
        return this.badEntries.get();
    }

    private boolean collects(int bit) {
        return (this.collect & bit) != 0;
    }

    private static class ExtraColumnsProblemReporter
    extends ProblemReporter {
        private String message;
        private final long row;
        private final String source;
        private final String value;

        ExtraColumnsProblemReporter(long row, String source, String value) {
            super(4);
            this.row = row;
            this.source = source;
            this.value = value;
        }

        @Override
        public String message() {
            return this.getReportMessage();
        }

        @Override
        public InputException exception() {
            return new InputException(this.getReportMessage());
        }

        private String getReportMessage() {
            if (this.message == null) {
                this.message = String.format("Extra column not present in header on line %d in %s with value %s", this.row, this.source, this.value);
            }
            return this.message;
        }
    }

    private static class NodesProblemReporter
    extends ProblemReporter {
        private final Object id;
        private final String group;

        NodesProblemReporter(Object id, String group) {
            super(2);
            this.id = id;
            this.group = group;
        }

        @Override
        public String message() {
            return DuplicateInputIdException.message(this.id, this.group);
        }

        @Override
        public InputException exception() {
            return new DuplicateInputIdException(this.id, this.group);
        }
    }

    private static class RelationshipsProblemReporter
    extends ProblemReporter {
        private String message;
        private final Object specificValue;
        private final Object startId;
        private final String startIdGroup;
        private final String type;
        private final Object endId;
        private final String endIdGroup;

        RelationshipsProblemReporter(Object startId, String startIdGroup, String type, Object endId, String endIdGroup, Object specificValue) {
            super(1);
            this.startId = startId;
            this.startIdGroup = startIdGroup;
            this.type = type;
            this.endId = endId;
            this.endIdGroup = endIdGroup;
            this.specificValue = specificValue;
        }

        @Override
        public String message() {
            return this.getReportMessage();
        }

        @Override
        public InputException exception() {
            return new InputException(this.getReportMessage());
        }

        private String getReportMessage() {
            if (this.message == null) {
                this.message = !this.isMissingData() ? String.format("%s (%s)-[%s]->%s (%s) referring to missing node %s", this.startId, this.startIdGroup, this.type, this.endId, this.endIdGroup, this.specificValue) : String.format("%s (%s)-[%s]->%s (%s) is missing data", this.startId, this.startIdGroup, this.type, this.endId, this.endIdGroup);
            }
            return this.message;
        }

        private boolean isMissingData() {
            return this.startId == null || this.endId == null || this.type == null;
        }
    }

    static abstract class ProblemReporter
    extends AsyncEvent {
        private final int type;

        ProblemReporter(int type) {
            this.type = type;
        }

        int type() {
            return this.type;
        }

        abstract String message();

        abstract InputException exception();
    }
}

