/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.ExplicitIndexProviderLookup;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreFileMetadata;

public class NeoStoreFileListing {
    private final File storeDir;
    private final LogFiles logFiles;
    private final LabelScanStore labelScanStore;
    private final IndexingService indexingService;
    private final ExplicitIndexProviderLookup explicitIndexProviders;
    private final StorageEngine storageEngine;
    private final Function<File, StoreFileMetadata> toNotAStoreTypeFile = file -> new StoreFileMetadata((File)file, 1);
    private final Function<File, StoreFileMetadata> logFileMapper = file -> new StoreFileMetadata((File)file, 1, true);

    public NeoStoreFileListing(File storeDir, LogFiles logFiles, LabelScanStore labelScanStore, IndexingService indexingService, ExplicitIndexProviderLookup explicitIndexProviders, StorageEngine storageEngine) {
        this.storeDir = storeDir;
        this.logFiles = logFiles;
        this.labelScanStore = labelScanStore;
        this.indexingService = indexingService;
        this.explicitIndexProviders = explicitIndexProviders;
        this.storageEngine = storageEngine;
    }

    public ResourceIterator<StoreFileMetadata> listStoreFiles(boolean includeLogs) throws IOException {
        ArrayList<StoreFileMetadata> files = new ArrayList<StoreFileMetadata>();
        this.gatherNonRecordStores(files, includeLogs);
        this.gatherNeoStoreFiles(files);
        Resource labelScanStoreSnapshot = this.gatherLabelScanStoreFiles(files);
        Resource schemaIndexSnapshots = this.gatherSchemaIndexFiles(files);
        Resource explicitIndexSnapshots = this.gatherExplicitIndexFiles(files);
        this.placeMetaDataStoreLast(files);
        return Iterators.resourceIterator(files.iterator(), (Resource)new MultiResource(Arrays.asList(labelScanStoreSnapshot, schemaIndexSnapshots, explicitIndexSnapshots)));
    }

    private void placeMetaDataStoreLast(List<StoreFileMetadata> files) {
        StoreFileMetadata file;
        Optional<StoreType> storeType;
        int index = 0;
        Iterator<StoreFileMetadata> iterator = files.iterator();
        while (!(!iterator.hasNext() || (storeType = StoreType.typeOf((file = iterator.next()).file().getName())).isPresent() && storeType.get().equals((Object)StoreType.META_DATA))) {
            ++index;
        }
        if (index < files.size() - 1) {
            StoreFileMetadata metaDataStoreFile = files.remove(index);
            files.add(metaDataStoreFile);
        }
    }

    private void gatherNonRecordStores(Collection<StoreFileMetadata> files, boolean includeLogs) {
        File[] indexFiles = this.storeDir.listFiles((dir, name) -> name.equals("index.db"));
        if (indexFiles != null) {
            for (File file : indexFiles) {
                files.add(this.toNotAStoreTypeFile.apply(file));
            }
        }
        if (includeLogs) {
            File[] logFiles;
            for (File logFile : logFiles = this.logFiles.logFiles()) {
                files.add(this.logFileMapper.apply(logFile));
            }
        }
    }

    private Resource gatherExplicitIndexFiles(Collection<StoreFileMetadata> files) throws IOException {
        ArrayList<ResourceIterator<File>> snapshots = new ArrayList<ResourceIterator<File>>();
        for (IndexImplementation indexProvider : this.explicitIndexProviders.all()) {
            ResourceIterator<File> snapshot = indexProvider.listStoreFiles();
            snapshots.add(snapshot);
            files.addAll(this.getSnapshotFilesMetadata(snapshot));
        }
        return new MultiResource(snapshots);
    }

    private Resource gatherSchemaIndexFiles(Collection<StoreFileMetadata> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.indexingService.snapshotStoreFiles();
        targetFiles.addAll(this.getSnapshotFilesMetadata(snapshot));
        return snapshot;
    }

    private Resource gatherLabelScanStoreFiles(Collection<StoreFileMetadata> targetFiles) throws IOException {
        ResourceIterator<File> snapshot = this.labelScanStore.snapshotStoreFiles();
        targetFiles.addAll(this.getSnapshotFilesMetadata(snapshot));
        return snapshot;
    }

    private List<StoreFileMetadata> getSnapshotFilesMetadata(ResourceIterator<File> snapshot) {
        return snapshot.stream().map(this.toNotAStoreTypeFile).collect(Collectors.toList());
    }

    private void gatherNeoStoreFiles(Collection<StoreFileMetadata> targetFiles) {
        targetFiles.addAll(this.storageEngine.listStorageFiles());
    }

    private static final class MultiResource
    implements Resource {
        private final Collection<? extends Resource> snapshots;

        private MultiResource(Collection<? extends Resource> resources) {
            this.snapshots = resources;
        }

        public void close() {
            RuntimeException exception = null;
            for (Resource resource : this.snapshots) {
                try {
                    resource.close();
                }
                catch (RuntimeException e) {
                    exception = e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

