/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;

public class DefaultSchemaIndexProviderMap
implements SchemaIndexProviderMap {
    private final SchemaIndexProvider defaultIndexProvider;
    private final Map<SchemaIndexProvider.Descriptor, SchemaIndexProvider> indexProviders = new HashMap<SchemaIndexProvider.Descriptor, SchemaIndexProvider>();

    public DefaultSchemaIndexProviderMap(SchemaIndexProvider defaultIndexProvider) {
        this(defaultIndexProvider, Collections.emptyList());
    }

    public DefaultSchemaIndexProviderMap(SchemaIndexProvider defaultIndexProvider, Iterable<SchemaIndexProvider> additionalIndexProviders) {
        this.defaultIndexProvider = defaultIndexProvider;
        this.indexProviders.put(defaultIndexProvider.getProviderDescriptor(), defaultIndexProvider);
        for (SchemaIndexProvider provider : additionalIndexProviders) {
            SchemaIndexProvider.Descriptor providerDescriptor = provider.getProviderDescriptor();
            Objects.requireNonNull(providerDescriptor);
            SchemaIndexProvider existing = this.indexProviders.putIfAbsent(providerDescriptor, provider);
            if (existing == null) continue;
            throw new IllegalArgumentException("Tried to load multiple schema index providers with the same provider descriptor " + providerDescriptor + ". First loaded " + existing + " then " + provider);
        }
    }

    @Override
    public SchemaIndexProvider getDefaultProvider() {
        return this.defaultIndexProvider;
    }

    @Override
    public SchemaIndexProvider apply(SchemaIndexProvider.Descriptor descriptor) {
        SchemaIndexProvider provider = this.indexProviders.get(descriptor);
        if (provider != null) {
            return provider;
        }
        throw new IllegalArgumentException("Tried to get index provider for an existing index with provider " + descriptor + " whereas available providers in this session being " + this.indexProviders + ", and default being " + this.defaultIndexProvider);
    }

    @Override
    public void accept(Consumer<SchemaIndexProvider> visitor) {
        this.indexProviders.values().forEach(visitor);
    }
}

