/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storageengine.impl.recordstorage;

import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.store.AllIdIterator;
import org.neo4j.kernel.impl.api.store.StoreIteratorRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StoreNodeRelationshipCursor;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleNodeCursor;
import org.neo4j.kernel.impl.api.store.StoreSinglePropertyCursor;
import org.neo4j.kernel.impl.api.store.StoreSingleRelationshipCursor;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandCreationContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.util.InstanceCache;
import org.neo4j.storageengine.api.Direction;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.RelationshipItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class StoreStatement
implements StorageStatement {
    private final InstanceCache<StoreSingleNodeCursor> singleNodeCursor;
    private final InstanceCache<StoreSingleRelationshipCursor> singleRelationshipCursor;
    private final InstanceCache<StoreIteratorRelationshipCursor> iteratorRelationshipCursor;
    private final InstanceCache<StoreNodeRelationshipCursor> nodeRelationshipsCursor;
    private final InstanceCache<StoreSinglePropertyCursor> singlePropertyCursorCache;
    private final InstanceCache<StorePropertyCursor> propertyCursorCache;
    private final NeoStores neoStores;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore relationshipGroupStore;
    private final PropertyStore propertyStore;
    private final Supplier<IndexReaderFactory> indexReaderFactorySupplier;
    private final RecordCursors recordCursors;
    private final Supplier<LabelScanReader> labelScanStore;
    private final RecordStorageCommandCreationContext commandCreationContext;
    private IndexReaderFactory indexReaderFactory;
    private LabelScanReader labelScanReader;
    private boolean acquired;
    private boolean closed;

    public StoreStatement(NeoStores neoStores, Supplier<IndexReaderFactory> indexReaderFactory, Supplier<LabelScanReader> labelScanReaderSupplier, final LockService lockService, RecordStorageCommandCreationContext commandCreationContext) {
        this.neoStores = neoStores;
        this.indexReaderFactorySupplier = indexReaderFactory;
        this.labelScanStore = labelScanReaderSupplier;
        this.commandCreationContext = commandCreationContext;
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.relationshipGroupStore = neoStores.getRelationshipGroupStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.recordCursors = new RecordCursors(neoStores);
        this.singleNodeCursor = new InstanceCache<StoreSingleNodeCursor>(){

            @Override
            protected StoreSingleNodeCursor create() {
                return new StoreSingleNodeCursor((NodeRecord)StoreStatement.this.nodeStore.newRecord(), this, StoreStatement.this.recordCursors, lockService);
            }
        };
        this.singleRelationshipCursor = new InstanceCache<StoreSingleRelationshipCursor>(){

            @Override
            protected StoreSingleRelationshipCursor create() {
                return new StoreSingleRelationshipCursor((RelationshipRecord)StoreStatement.this.relationshipStore.newRecord(), this, StoreStatement.this.recordCursors, lockService);
            }
        };
        this.iteratorRelationshipCursor = new InstanceCache<StoreIteratorRelationshipCursor>(){

            @Override
            protected StoreIteratorRelationshipCursor create() {
                return new StoreIteratorRelationshipCursor((RelationshipRecord)StoreStatement.this.relationshipStore.newRecord(), this, StoreStatement.this.recordCursors, lockService);
            }
        };
        this.nodeRelationshipsCursor = new InstanceCache<StoreNodeRelationshipCursor>(){

            @Override
            protected StoreNodeRelationshipCursor create() {
                return new StoreNodeRelationshipCursor((RelationshipRecord)StoreStatement.this.relationshipStore.newRecord(), (RelationshipGroupRecord)StoreStatement.this.relationshipGroupStore.newRecord(), this, StoreStatement.this.recordCursors, lockService);
            }
        };
        this.singlePropertyCursorCache = new InstanceCache<StoreSinglePropertyCursor>(){

            @Override
            protected StoreSinglePropertyCursor create() {
                return new StoreSinglePropertyCursor(StoreStatement.this.recordCursors, this);
            }
        };
        this.propertyCursorCache = new InstanceCache<StorePropertyCursor>(){

            @Override
            protected StorePropertyCursor create() {
                return new StorePropertyCursor(StoreStatement.this.recordCursors, this);
            }
        };
    }

    @Override
    public void acquire() {
        assert (!this.closed);
        assert (!this.acquired);
        this.acquired = true;
    }

    @Override
    public Cursor<NodeItem> acquireSingleNodeCursor(long nodeId) {
        this.neoStores.assertOpen();
        return this.singleNodeCursor.get().init(nodeId);
    }

    @Override
    public Cursor<RelationshipItem> acquireSingleRelationshipCursor(long relId) {
        this.neoStores.assertOpen();
        return this.singleRelationshipCursor.get().init(relId);
    }

    @Override
    public Cursor<RelationshipItem> acquireNodeRelationshipCursor(boolean isDense, long nodeId, long relationshipId, Direction direction, IntPredicate relTypeFilter) {
        this.neoStores.assertOpen();
        return this.nodeRelationshipsCursor.get().init(isDense, relationshipId, nodeId, direction, relTypeFilter);
    }

    @Override
    public Cursor<RelationshipItem> relationshipsGetAllCursor() {
        this.neoStores.assertOpen();
        return this.iteratorRelationshipCursor.get().init((PrimitiveLongIterator)new AllIdIterator(this.relationshipStore));
    }

    @Override
    public Cursor<PropertyItem> acquirePropertyCursor(long propertyId, Lock lock, AssertOpen assertOpen) {
        return this.propertyCursorCache.get().init(propertyId, lock, assertOpen);
    }

    @Override
    public Cursor<PropertyItem> acquireSinglePropertyCursor(long propertyId, int propertyKeyId, Lock lock, AssertOpen assertOpen) {
        return this.singlePropertyCursorCache.get().init(propertyId, propertyKeyId, lock, assertOpen);
    }

    @Override
    public void release() {
        assert (!this.closed);
        assert (this.acquired);
        this.closeSchemaResources();
        this.acquired = false;
    }

    @Override
    public void close() {
        assert (!this.closed);
        this.closeSchemaResources();
        this.recordCursors.close();
        this.commandCreationContext.close();
        this.closed = true;
    }

    private void closeSchemaResources() {
        if (this.indexReaderFactory != null) {
            this.indexReaderFactory.close();
        }
        if (this.labelScanReader != null) {
            this.labelScanReader.close();
            this.labelScanReader = null;
        }
    }

    @Override
    public LabelScanReader getLabelScanReader() {
        return this.labelScanReader != null ? this.labelScanReader : (this.labelScanReader = this.labelScanStore.get());
    }

    private IndexReaderFactory indexReaderFactory() {
        return this.indexReaderFactory != null ? this.indexReaderFactory : (this.indexReaderFactory = this.indexReaderFactorySupplier.get());
    }

    @Override
    public IndexReader getIndexReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory().newReader(descriptor);
    }

    @Override
    public IndexReader getFreshIndexReader(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexReaderFactory().newUnCachedReader(descriptor);
    }

    @Override
    public RecordCursors recordCursors() {
        return this.recordCursors;
    }

    RecordStorageCommandCreationContext getCommandCreationContext() {
        return this.commandCreationContext;
    }

    @Override
    public long reserveNode() {
        return this.commandCreationContext.nextId(StoreType.NODE);
    }

    @Override
    public long reserveRelationship() {
        return this.commandCreationContext.nextId(StoreType.RELATIONSHIP);
    }

    @Override
    public StorageStatement.Nodes nodes() {
        return this.nodeStore;
    }

    @Override
    public StorageStatement.Relationships relationships() {
        return this.relationshipStore;
    }

    @Override
    public StorageStatement.Groups groups() {
        return this.relationshipGroupStore;
    }

    @Override
    public StorageStatement.Properties properties() {
        return this.propertyStore;
    }
}

