/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collections;
import java.util.Set;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.RelationshipCursor;

class RelationshipScanCursor
extends RelationshipCursor
implements org.neo4j.internal.kernel.api.RelationshipScanCursor {
    private int label;
    private long next;
    private long highMark;
    private PageCursor pageCursor;
    Set<Long> addedRelationships;

    RelationshipScanCursor() {
    }

    void scan(int label, Read read) {
        if (this.getId() != -1L) {
            this.reset();
        }
        if (this.pageCursor == null) {
            this.pageCursor = read.relationshipPage(0L);
        }
        this.next = 0L;
        this.label = label;
        this.highMark = read.relationshipHighMark();
        this.init(read);
        this.addedRelationships = Collections.emptySet();
    }

    void single(long reference, Read read) {
        if (this.getId() != -1L) {
            this.reset();
        }
        if (this.pageCursor == null) {
            this.pageCursor = read.relationshipPage(reference);
        }
        this.next = reference;
        this.label = -1;
        this.highMark = -1L;
        this.init(read);
        this.addedRelationships = Collections.emptySet();
    }

    public boolean next() {
        TransactionState txs;
        if (this.next == -1L) {
            this.reset();
            return false;
        }
        boolean hasChanges = this.hasChanges();
        TransactionState transactionState = txs = hasChanges ? this.read.txState() : null;
        do {
            if (hasChanges && this.containsRelationship(txs)) {
                this.loadFromTxState(this.next++);
                this.setInUse(true);
            } else if (hasChanges && txs.relationshipIsDeletedInThisTx(this.next)) {
                ++this.next;
                this.setInUse(false);
            } else {
                this.read.relationship(this, this.next++, this.pageCursor);
            }
            if (this.next <= this.highMark) continue;
            if (this.isSingle()) {
                this.next = -1L;
                return this.isWantedLabelAndInUse();
            }
            this.highMark = this.read.relationshipHighMark();
            if (this.next <= this.highMark) continue;
            this.next = -1L;
            return this.isWantedLabelAndInUse();
        } while (!this.isWantedLabelAndInUse());
        return true;
    }

    private boolean isWantedLabelAndInUse() {
        return (this.label == -1 || this.label() == this.label) && this.inUse();
    }

    private boolean containsRelationship(TransactionState txs) {
        return this.isSingle() ? txs.relationshipIsAddedInThisTx(this.next) : this.addedRelationships.contains(this.next);
    }

    public boolean shouldRetry() {
        return false;
    }

    public void close() {
        if (this.pageCursor != null) {
            this.pageCursor.close();
            this.pageCursor = null;
        }
        this.read = null;
        this.reset();
    }

    private void reset() {
        this.next = -1L;
        this.setId(-1L);
    }

    public boolean isClosed() {
        return this.pageCursor == null;
    }

    @Override
    public String toString() {
        if (this.isClosed()) {
            return "RelationshipScanCursor[closed state]";
        }
        return "RelationshipScanCursor[id=" + this.getId() + ", open state with: highMark=" + this.highMark + ", next=" + this.next + ", label=" + this.label + ", underlying record=" + super.toString() + " ]";
    }

    private boolean isSingle() {
        return this.highMark == -1L;
    }

    @Override
    protected void collectAddedTxStateSnapshot() {
        if (!this.isSingle()) {
            this.addedRelationships = this.read.txState().addedAndRemovedRelationships().getAddedSnapshot();
        }
    }
}

