/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.RelationshipDirection;
import org.neo4j.kernel.impl.newapi.RelationshipReferenceEncoding;
import org.neo4j.kernel.impl.newapi.RelationshipTraversalCursor;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

class RelationshipGroupCursor
extends RelationshipGroupRecord
implements org.neo4j.internal.kernel.api.RelationshipGroupCursor {
    private Read read;
    private final RelationshipRecord edge = new RelationshipRecord(-1L);
    private BufferedGroup bufferedGroup;
    private PageCursor page;
    private PageCursor edgePage;

    RelationshipGroupCursor() {
        super(-1L);
    }

    void buffer(long nodeReference, long relationshipReference, Read read) {
        this.setOwningNode(nodeReference);
        this.setId(-1L);
        this.setNext(-1L);
        try (PrimitiveIntObjectMap buffer = Primitive.intObjectMap();
             PageCursor edgePage = read.relationshipPage(relationshipReference);){
            BufferedGroup current = null;
            while (relationshipReference != -1L) {
                read.relationship(this.edge, relationshipReference, edgePage);
                BufferedGroup group = (BufferedGroup)buffer.get(this.edge.getType());
                if (group == null) {
                    current = group = new BufferedGroup(this.edge, current);
                    buffer.put(this.edge.getType(), (Object)group);
                }
                if (this.edge.getFirstNode() == nodeReference) {
                    if (this.edge.getSecondNode() == nodeReference) {
                        group.loop(this.edge);
                    } else {
                        group.outgoing(this.edge);
                    }
                    relationshipReference = this.edge.getFirstNextRel();
                    continue;
                }
                if (this.edge.getSecondNode() == nodeReference) {
                    group.incoming(this.edge);
                    relationshipReference = this.edge.getSecondNextRel();
                    continue;
                }
                throw new IllegalStateException("not a part of the chain! TODO: better exception");
            }
            this.bufferedGroup = new BufferedGroup(this.edge, current);
            this.read = read;
        }
    }

    void direct(long nodeReference, long reference, Read read) {
        this.setOwningNode(nodeReference);
        this.bufferedGroup = null;
        this.clear();
        this.setNext(reference);
        if (this.page == null) {
            this.page = read.groupPage(reference);
        }
        this.read = read;
    }

    public RelationshipGroupCursor.Position suspend() {
        throw new UnsupportedOperationException("not implemented");
    }

    public void resume(RelationshipGroupCursor.Position position) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean next() {
        if (this.isBuffered()) {
            this.bufferedGroup = this.bufferedGroup.next;
            if (this.bufferedGroup == null) {
                return false;
            }
            this.setType(this.bufferedGroup.label);
            this.setFirstOut(this.bufferedGroup.outgoing());
            this.setFirstIn(this.bufferedGroup.incoming());
            this.setFirstLoop(this.bufferedGroup.loops());
            return true;
        }
        if (this.getNext() == -1L) {
            return false;
        }
        this.read.group(this, this.getNext(), this.page);
        return true;
    }

    public boolean shouldRetry() {
        return false;
    }

    public void close() {
        if (this.page != null) {
            this.page.close();
            this.page = null;
        }
        if (this.edgePage != null) {
            this.edgePage.close();
            this.edgePage = null;
        }
        this.bufferedGroup = null;
        this.read = null;
        this.setId(-1L);
        this.clear();
    }

    public int relationshipLabel() {
        return this.getType();
    }

    public int outgoingCount() {
        if (this.isBuffered()) {
            return this.bufferedGroup.outgoingCount;
        }
        return this.count(this.outgoingRawId());
    }

    public int incomingCount() {
        if (this.isBuffered()) {
            return this.bufferedGroup.incomingCount;
        }
        return this.count(this.incomingRawId());
    }

    public int loopCount() {
        if (this.isBuffered()) {
            return this.bufferedGroup.loopsCount;
        }
        return this.count(this.loopsRawId());
    }

    private int count(long reference) {
        if (reference == -1L) {
            return 0;
        }
        if (this.edgePage == null) {
            this.edgePage = this.read.relationshipPage(reference);
        }
        this.read.relationship(this.edge, reference, this.edgePage);
        if (this.edge.getFirstNode() == this.getOwningNode()) {
            return (int)this.edge.getFirstPrevRel();
        }
        return (int)this.edge.getSecondPrevRel();
    }

    public void outgoing(org.neo4j.internal.kernel.api.RelationshipTraversalCursor cursor) {
        if (this.isBuffered()) {
            ((RelationshipTraversalCursor)cursor).buffered(this.getOwningNode(), this.bufferedGroup.outgoing, RelationshipDirection.OUTGOING, this.bufferedGroup.label, this.read);
        } else {
            this.read.relationships(this.getOwningNode(), this.outgoingReference(), cursor);
        }
    }

    public void incoming(org.neo4j.internal.kernel.api.RelationshipTraversalCursor cursor) {
        if (this.isBuffered()) {
            ((RelationshipTraversalCursor)cursor).buffered(this.getOwningNode(), this.bufferedGroup.incoming, RelationshipDirection.INCOMING, this.bufferedGroup.label, this.read);
        } else {
            this.read.relationships(this.getOwningNode(), this.incomingReference(), cursor);
        }
    }

    public void loops(org.neo4j.internal.kernel.api.RelationshipTraversalCursor cursor) {
        if (this.isBuffered()) {
            ((RelationshipTraversalCursor)cursor).buffered(this.getOwningNode(), this.bufferedGroup.loops, RelationshipDirection.LOOP, this.bufferedGroup.label, this.read);
        } else {
            this.read.relationships(this.getOwningNode(), this.loopsReference(), cursor);
        }
    }

    public long outgoingReference() {
        long outgoing = this.getFirstOut();
        return outgoing == -1L ? RelationshipReferenceEncoding.encodeNoOutgoingRels(this.getType()) : this.encodeRelationshipReference(outgoing);
    }

    public long incomingReference() {
        long incoming = this.getFirstIn();
        return incoming == -1L ? RelationshipReferenceEncoding.encodeNoIncomingRels(this.getType()) : this.encodeRelationshipReference(incoming);
    }

    public long loopsReference() {
        long loops = this.getFirstLoop();
        return loops == -1L ? RelationshipReferenceEncoding.encodeNoLoopRels(this.getType()) : this.encodeRelationshipReference(loops);
    }

    public boolean isClosed() {
        return this.page == null && this.bufferedGroup == null;
    }

    @Override
    public String toString() {
        if (this.isClosed()) {
            return "RelationshipGroupCursor[closed state]";
        }
        String mode = "mode=";
        mode = this.isBuffered() ? mode + "group" : mode + "direct";
        return "RelationshipGroupCursor[id=" + this.getId() + ", open state with: " + mode + ", underlying record=" + super.toString() + " ]";
    }

    long outgoingRawId() {
        return this.getFirstOut();
    }

    long incomingRawId() {
        return this.getFirstIn();
    }

    long loopsRawId() {
        return this.getFirstLoop();
    }

    private boolean isBuffered() {
        return this.bufferedGroup != null;
    }

    private long encodeRelationshipReference(long relationshipId) {
        assert (relationshipId != -1L);
        return this.isBuffered() ? RelationshipReferenceEncoding.encodeForFiltering(relationshipId) : RelationshipReferenceEncoding.encodeForTxStateFiltering(relationshipId);
    }

    static class BufferedGroup {
        final int label;
        final BufferedGroup next;
        RelationshipTraversalCursor.Record outgoing;
        RelationshipTraversalCursor.Record incoming;
        RelationshipTraversalCursor.Record loops;
        private long firstOut = -1L;
        private long firstIn = -1L;
        private long firstLoop = -1L;
        int outgoingCount;
        int incomingCount;
        int loopsCount;

        BufferedGroup(RelationshipRecord edge, BufferedGroup next) {
            this.label = edge.getType();
            this.next = next;
        }

        void outgoing(RelationshipRecord edge) {
            if (this.outgoing == null) {
                this.firstOut = edge.getId();
            }
            this.outgoing = new RelationshipTraversalCursor.Record(edge, this.outgoing);
            ++this.outgoingCount;
        }

        void incoming(RelationshipRecord edge) {
            if (this.incoming == null) {
                this.firstIn = edge.getId();
            }
            this.incoming = new RelationshipTraversalCursor.Record(edge, this.incoming);
            ++this.incomingCount;
        }

        void loop(RelationshipRecord edge) {
            if (this.loops == null) {
                this.firstLoop = edge.getId();
            }
            this.loops = new RelationshipTraversalCursor.Record(edge, this.loops);
            ++this.loopsCount;
        }

        long outgoing() {
            return this.firstOut;
        }

        long incoming() {
            return this.firstIn;
        }

        long loops() {
            return this.firstLoop;
        }
    }
}

