/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.schema;

import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.storageengine.api.schema.NodeValueIndexProgressor;
import org.neo4j.values.storable.Value;

public interface IndexReader
extends Resource {
    public static final IndexReader EMPTY = new IndexReader(){

        @Override
        public long countIndexedNodes(long nodeId, Value ... propertyValues) {
            return 0L;
        }

        @Override
        public IndexSampler createSampler() {
            return IndexSampler.EMPTY;
        }

        @Override
        public PrimitiveLongResourceIterator query(IndexQuery[] predicates) {
            return PrimitiveLongResourceCollections.emptyIterator();
        }

        public void close() {
        }

        @Override
        public boolean hasFullNumberPrecision(IndexQuery ... predicates) {
            return true;
        }
    };

    public long countIndexedNodes(long var1, Value ... var3);

    public IndexSampler createSampler();

    public PrimitiveLongResourceIterator query(IndexQuery ... var1) throws IndexNotApplicableKernelException;

    default public void query(IndexProgressor.NodeValueClient client, IndexOrder indexOrder, IndexQuery ... query) throws IndexNotApplicableKernelException {
        if (indexOrder != IndexOrder.NONE) {
            throw new UnsupportedOperationException(String.format("This reader only have support for index order %s. Provided index order was %s.", IndexOrder.NONE, indexOrder));
        }
        int[] keys = new int[query.length];
        for (int i = 0; i < query.length; ++i) {
            keys[i] = query[i].propertyKeyId();
        }
        client.initialize(new NodeValueIndexProgressor(this.query(query), client), keys);
    }

    public boolean hasFullNumberPrecision(IndexQuery ... var1);
}

