/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.util.NodeProxyWrappingNodeValue;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.EdgeValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.VirtualValues;

public class RelationshipProxyWrappingEdgeValue
extends EdgeValue {
    private final Relationship relationship;
    private volatile TextValue type;
    private volatile MapValue properties;
    private volatile NodeValue startNode;
    private volatile NodeValue endNode;

    RelationshipProxyWrappingEdgeValue(Relationship relationship) {
        super(relationship.getId());
        this.relationship = relationship;
    }

    public Relationship relationshipProxy() {
        return this.relationship;
    }

    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        MapValue p;
        try {
            p = this.properties();
        }
        catch (NotFoundException e) {
            p = VirtualValues.EMPTY_MAP;
        }
        if (this.id() < 0L) {
            writer.writeVirtualEdgeHack((Object)this.relationship);
        }
        writer.writeEdge(this.id(), this.startNode().id(), this.endNode().id(), this.type(), p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeValue startNode() {
        NodeValue start = this.startNode;
        if (start == null) {
            RelationshipProxyWrappingEdgeValue relationshipProxyWrappingEdgeValue = this;
            synchronized (relationshipProxyWrappingEdgeValue) {
                start = this.startNode;
                if (start == null) {
                    start = this.startNode = ValueUtils.fromNodeProxy(this.relationship.getStartNode());
                }
            }
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeValue endNode() {
        NodeValue end = this.endNode;
        if (end == null) {
            RelationshipProxyWrappingEdgeValue relationshipProxyWrappingEdgeValue = this;
            synchronized (relationshipProxyWrappingEdgeValue) {
                end = this.endNode;
                if (end == null) {
                    end = this.endNode = ValueUtils.fromNodeProxy(this.relationship.getEndNode());
                }
            }
        }
        return end;
    }

    public NodeValue otherNode(NodeValue node) {
        if (node instanceof NodeProxyWrappingNodeValue) {
            Node proxy = ((NodeProxyWrappingNodeValue)node).nodeProxy();
            return ValueUtils.fromNodeProxy(this.relationship.getOtherNode(proxy));
        }
        return super.otherNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextValue type() {
        TextValue t = this.type;
        if (t == null) {
            RelationshipProxyWrappingEdgeValue relationshipProxyWrappingEdgeValue = this;
            synchronized (relationshipProxyWrappingEdgeValue) {
                t = this.type;
                if (t == null) {
                    t = this.type = Values.stringValue((String)this.relationship.getType().name());
                }
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapValue properties() {
        MapValue m = this.properties;
        if (m == null) {
            RelationshipProxyWrappingEdgeValue relationshipProxyWrappingEdgeValue = this;
            synchronized (relationshipProxyWrappingEdgeValue) {
                m = this.properties;
                if (m == null) {
                    m = this.properties = ValueUtils.asMapValue(this.relationship.getAllProperties());
                }
            }
        }
        return m;
    }
}

