/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.neo4j.helpers.OptionalHostnamePort;
import org.neo4j.kernel.impl.util.NumberAwareStringComparator;
import org.neo4j.kernel.impl.util.Validators;

public class Converters {
    public static final Comparator<File> BY_FILE_NAME = Comparator.comparing(File::getName);
    public static final Comparator<File> BY_FILE_NAME_WITH_CLEVER_NUMBERS = (o1, o2) -> NumberAwareStringComparator.INSTANCE.compare(o1.getAbsolutePath(), o2.getAbsolutePath());

    private Converters() {
    }

    public static <T> Function<String, T> mandatory() {
        return key -> {
            throw new IllegalArgumentException("Missing argument '" + key + "'");
        };
    }

    public static <T> Function<String, T> optional() {
        return from -> null;
    }

    public static <T> Function<String, T> withDefault(T defaultValue) {
        return from -> defaultValue;
    }

    public static Function<String, File> toFile() {
        return File::new;
    }

    public static Function<String, Path> toPath() {
        return x$0 -> Paths.get(x$0, new String[0]);
    }

    public static Function<String, String> identity() {
        return s -> s;
    }

    public static Function<String, File[]> regexFiles(boolean cleverNumberRegexSort) {
        return name -> {
            Comparator<File> sorting = cleverNumberRegexSort ? BY_FILE_NAME_WITH_CLEVER_NUMBERS : BY_FILE_NAME;
            List<File> files = Validators.matchingFiles(new File((String)name));
            files.sort(sorting);
            return files.toArray(new File[files.size()]);
        };
    }

    public static Function<String, File[]> toFiles(String delimiter, Function<String, File[]> eachFileConverter) {
        return from -> {
            if (from == null) {
                return new File[0];
            }
            String[] names = from.split(delimiter);
            ArrayList<Object> files = new ArrayList<Object>();
            for (String name : names) {
                files.addAll(Arrays.asList((Object[])eachFileConverter.apply(name)));
            }
            return files.toArray(new File[files.size()]);
        };
    }

    public static Function<String, Integer> toInt() {
        return Integer::new;
    }

    public static OptionalHostnamePort toOptionalHostnamePortFromRawAddress(String rawAddress) {
        return new OptionalHostnamePort(Converters.toHostnameFromRawAddress(rawAddress), Converters.toPortFromRawAddress(rawAddress), Converters.toPortUpperRangeFromRawAddress(rawAddress));
    }

    private static Optional<String> toHostnameFromRawAddress(String rawAddress) {
        return Optional.ofNullable(rawAddress).map(addr -> addr.split(":")[0]).filter(addr -> !"".equals(addr));
    }

    private static Optional<Integer> toPortFromRawAddress(String rawAddress) {
        return Optional.ofNullable(rawAddress).map(addr -> addr.split(":")).filter(parts -> ((String[])parts).length >= 2).map(parts -> parts[1]).map(Integer::parseInt);
    }

    private static Optional<Integer> toPortUpperRangeFromRawAddress(String rawAddress) {
        return Optional.ofNullable(rawAddress).map(addr -> addr.split(":")).filter(parts -> ((String[])parts).length == 3).map(parts -> parts[2]).map(Integer::parseInt);
    }
}

