/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;

public class ThresholdBasedPruneStrategy
implements LogPruneStrategy {
    private final FileSystemAbstraction fileSystem;
    private final LogFiles files;
    private final Threshold threshold;
    private final TransactionLogFileInformation logFileInformation;

    ThresholdBasedPruneStrategy(FileSystemAbstraction fileSystem, LogFiles logFiles, Threshold threshold) {
        this.fileSystem = fileSystem;
        this.files = logFiles;
        this.logFileInformation = this.files.getLogFileInformation();
        this.threshold = threshold;
    }

    @Override
    public void prune(long upToVersion, LogPruneStrategy.Monitor monitor) {
        long upper;
        if (upToVersion == 0L) {
            return;
        }
        this.threshold.init();
        boolean exceeded = false;
        for (upper = upToVersion - 1L; upper >= 0L; --upper) {
            File file = this.files.getLogFileForVersion(upper);
            if (!this.fileSystem.fileExists(file)) {
                return;
            }
            if (this.fileSystem.getFileSize(file) <= 16L || !this.threshold.reached(file, upper, this.logFileInformation)) continue;
            exceeded = true;
            break;
        }
        if (!exceeded) {
            monitor.noLogsPruned(upToVersion);
            return;
        }
        long lower = upper;
        while (this.fileSystem.fileExists(this.files.getLogFileForVersion(lower - 1L))) {
            --lower;
        }
        if (upper == upToVersion - 1L) {
            --upper;
        }
        for (long version = lower; version <= upper; ++version) {
            this.fileSystem.deleteFile(this.files.getLogFileForVersion(version));
        }
        monitor.logsPruned(upToVersion, lower, upper);
    }
}

