/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFileCreationMonitor;

class TransactionLogFilesContext {
    private final long rotationThreshold;
    private final LogEntryReader logEntryReader;
    private final LongSupplier lastCommittedTransactionIdSupplier;
    private final Supplier<LogVersionRepository> logVersionRepositorySupplier;
    private final LogFileCreationMonitor logFileCreationMonitor;
    private final FileSystemAbstraction fileSystem;

    TransactionLogFilesContext(long rotationThreshold, LogEntryReader logEntryReader, LongSupplier lastCommittedTransactionIdSupplier, LogFileCreationMonitor logFileCreationMonitor, Supplier<LogVersionRepository> logVersionRepositorySupplier, FileSystemAbstraction fileSystem) {
        this.rotationThreshold = rotationThreshold;
        this.logEntryReader = logEntryReader;
        this.lastCommittedTransactionIdSupplier = lastCommittedTransactionIdSupplier;
        this.logVersionRepositorySupplier = logVersionRepositorySupplier;
        this.logFileCreationMonitor = logFileCreationMonitor;
        this.fileSystem = fileSystem;
    }

    long getRotationThreshold() {
        return this.rotationThreshold;
    }

    LogEntryReader getLogEntryReader() {
        return this.logEntryReader;
    }

    LogVersionRepository getLogVersionRepository() {
        return this.logVersionRepositorySupplier.get();
    }

    long getLastCommittedTransactionId() {
        return this.lastCommittedTransactionIdSupplier.getAsLong();
    }

    LogFileCreationMonitor getLogFileCreationMonitor() {
        return this.logFileCreationMonitor;
    }

    FileSystemAbstraction getFileSystem() {
        return this.fileSystem;
    }
}

