/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.function.Supplier;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.QueryRegistryOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.statistic.StatisticProvider;

public class Neo4jTransactionalContext
implements TransactionalContext {
    private final GraphDatabaseQueryService graph;
    private final Supplier<Statement> statementSupplier;
    private final Guard guard;
    private final ThreadToStatementContextBridge txBridge;
    private final PropertyContainerLocker locker;
    public final Transaction.Type transactionType;
    public final SecurityContext securityContext;
    private final ExecutingQuery executingQuery;
    private volatile InternalTransaction transaction;
    private Statement statement;
    private boolean isOpen = true;
    private long pageHits;
    private long pageMisses;

    public Neo4jTransactionalContext(GraphDatabaseQueryService graph, Supplier<Statement> statementSupplier, Guard guard, ThreadToStatementContextBridge txBridge, PropertyContainerLocker locker, InternalTransaction initialTransaction, Statement initialStatement, ExecutingQuery executingQuery) {
        this.graph = graph;
        this.statementSupplier = statementSupplier;
        this.guard = guard;
        this.txBridge = txBridge;
        this.locker = locker;
        this.transactionType = initialTransaction.transactionType();
        this.securityContext = initialTransaction.securityContext();
        this.executingQuery = executingQuery;
        this.transaction = initialTransaction;
        this.statement = initialStatement;
    }

    @Override
    public ExecutingQuery executingQuery() {
        return this.executingQuery;
    }

    @Override
    public ReadOperations readOperations() {
        return this.statement.readOperations();
    }

    @Override
    public DbmsOperations dbmsOperations() {
        return this.graph.getDbmsOperations();
    }

    @Override
    public boolean isTopLevelTx() {
        return this.transaction.transactionType() == Transaction.Type.implicit;
    }

    @Override
    public void close(boolean success) {
        if (this.isOpen) {
            try {
                this.statement.queryRegistration().unregisterExecutingQuery(this.executingQuery);
                this.statement.close();
                if (success) {
                    this.transaction.success();
                } else {
                    this.transaction.failure();
                }
                this.transaction.close();
            }
            finally {
                this.statement = null;
                this.transaction = null;
                this.isOpen = false;
            }
        }
    }

    @Override
    public void terminate() {
        InternalTransaction currentTransaction = this.transaction;
        if (currentTransaction != null) {
            currentTransaction.terminate();
        }
    }

    @Override
    public void commitAndRestartTx() {
        this.checkNotTerminated();
        this.collectTransactionExecutionStatistic();
        QueryRegistryOperations oldQueryRegistryOperations = this.statement.queryRegistration();
        Statement oldStatement = this.statement;
        InternalTransaction oldTransaction = this.transaction;
        KernelTransaction oldKernelTx = this.txBridge.getKernelTransactionBoundToThisThread(true);
        this.txBridge.unbindTransactionFromCurrentThread();
        this.transaction = this.graph.beginTransaction(this.transactionType, this.securityContext);
        this.statement = this.txBridge.get();
        this.statement.queryRegistration().registerExecutingQuery(this.executingQuery);
        KernelTransaction kernelTx = this.txBridge.getKernelTransactionBoundToThisThread(true);
        this.txBridge.unbindTransactionFromCurrentThread();
        this.txBridge.bindTransactionToCurrentThread(oldKernelTx);
        oldQueryRegistryOperations.unregisterExecutingQuery(this.executingQuery);
        try {
            oldStatement.close();
            oldTransaction.success();
            oldTransaction.close();
        }
        catch (Throwable t) {
            this.txBridge.bindTransactionToCurrentThread(kernelTx);
            this.transaction.failure();
            this.transaction.close();
            this.txBridge.unbindTransactionFromCurrentThread();
            throw t;
        }
        this.txBridge.unbindTransactionFromCurrentThread();
        this.txBridge.bindTransactionToCurrentThread(kernelTx);
    }

    @Override
    public void cleanForReuse() {
        this.statement.queryRegistration().unregisterExecutingQuery(this.executingQuery);
        this.statement.close();
        this.statement = this.statementSupplier.get();
        this.statement.queryRegistration().registerExecutingQuery(this.executingQuery);
    }

    @Override
    public TransactionalContext getOrBeginNewIfClosed() {
        this.checkNotTerminated();
        if (!this.isOpen) {
            this.transaction = this.graph.beginTransaction(this.transactionType, this.securityContext);
            this.statement = this.statementSupplier.get();
            this.statement.queryRegistration().registerExecutingQuery(this.executingQuery);
            this.isOpen = true;
        }
        return this;
    }

    public TransactionalContext beginInNewThread() {
        InternalTransaction newTx = this.graph.beginTransaction(this.transactionType, this.securityContext);
        return new Neo4jTransactionalContext(this.graph, this.statementSupplier, this.guard, this.txBridge, this.locker, newTx, this.statementSupplier.get(), this.executingQuery);
    }

    private void checkNotTerminated() {
        InternalTransaction currentTransaction = this.transaction;
        if (currentTransaction != null) {
            currentTransaction.terminationReason().ifPresent(status -> {
                throw new TransactionTerminatedException(status);
            });
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public GraphDatabaseQueryService graph() {
        return this.graph;
    }

    @Override
    public Statement statement() {
        return this.statement;
    }

    @Override
    public void check() {
        this.guard.check((KernelStatement)this.statement);
    }

    @Override
    public TxStateHolder stateView() {
        return (KernelStatement)this.statement;
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer p) {
        return this.locker.exclusiveLock(this.statement, p);
    }

    @Override
    public KernelTransaction.Revertable restrictCurrentTransaction(SecurityContext context) {
        return this.transaction.overrideWith(context);
    }

    @Override
    public SecurityContext securityContext() {
        return this.securityContext;
    }

    @Override
    public StatisticProvider kernelStatisticProvider() {
        return new TransactionalContextStatisticProvider(this.statement.executionStatisticsOperations().getPageCursorTracer());
    }

    private void collectTransactionExecutionStatistic() {
        PageCursorTracer pageCursorTracer = this.statement.executionStatisticsOperations().getPageCursorTracer();
        this.pageHits += pageCursorTracer.hits();
        this.pageMisses += pageCursorTracer.faults();
    }

    private class TransactionalContextStatisticProvider
    implements StatisticProvider {
        private final PageCursorTracer pageCursorTracer;

        private TransactionalContextStatisticProvider(PageCursorTracer pageCursorTracer) {
            this.pageCursorTracer = pageCursorTracer;
        }

        @Override
        public long getPageCacheHits() {
            return this.pageCursorTracer.hits() + Neo4jTransactionalContext.this.pageHits;
        }

        @Override
        public long getPageCacheMisses() {
            return this.pageCursorTracer.faults() + Neo4jTransactionalContext.this.pageMisses;
        }
    }

    static interface Creator {
        public Neo4jTransactionalContext create(Supplier<Statement> var1, InternalTransaction var2, Statement var3, ExecutingQuery var4);
    }
}

