/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.ExplicitIndexRead;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeExplicitIndexCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipExplicitIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.Scan;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.values.storable.Value;

public class Operations
implements Read,
ExplicitIndexRead,
SchemaRead {
    private final KernelTransactionImplementation ktx;
    private final AllStoreHolder allStoreHolder;

    public Operations(StorageEngine engine, StorageStatement statement, KernelTransactionImplementation ktx, Supplier<ExplicitIndexTransactionState> explicitIndexes) {
        this.allStoreHolder = new AllStoreHolder(engine, statement, explicitIndexes);
        this.ktx = ktx;
    }

    public void nodeIndexSeek(IndexReference index, NodeValueIndexCursor cursor, IndexOrder order, IndexQuery ... query) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.nodeIndexSeek(index, cursor, order, query);
    }

    public void nodeIndexScan(IndexReference index, NodeValueIndexCursor cursor, IndexOrder order) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.nodeIndexScan(index, cursor, order);
    }

    public void nodeLabelScan(int label, NodeLabelIndexCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.nodeLabelScan(label, cursor);
    }

    public void nodeLabelUnionScan(NodeLabelIndexCursor cursor, int ... labels) {
        this.assertOpen();
        this.allStoreHolder.nodeLabelUnionScan(cursor, labels);
    }

    public void nodeLabelIntersectionScan(NodeLabelIndexCursor cursor, int ... labels) {
        this.assertOpen();
        this.allStoreHolder.nodeLabelIntersectionScan(cursor, labels);
    }

    public Scan<NodeLabelIndexCursor> nodeLabelScan(int label) {
        this.assertOpen();
        return this.allStoreHolder.nodeLabelScan(label);
    }

    public void allNodesScan(NodeCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.allNodesScan(cursor);
    }

    public Scan<NodeCursor> allNodesScan() {
        this.assertOpen();
        return this.allStoreHolder.allNodesScan();
    }

    public void singleNode(long reference, NodeCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.singleNode(reference, cursor);
    }

    public void singleRelationship(long reference, RelationshipScanCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.singleRelationship(reference, cursor);
    }

    public void allRelationshipsScan(RelationshipScanCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.allRelationshipsScan(cursor);
    }

    public Scan<RelationshipScanCursor> allRelationshipsScan() {
        this.assertOpen();
        return this.allStoreHolder.allRelationshipsScan();
    }

    public void relationshipLabelScan(int label, RelationshipScanCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.relationshipLabelScan(label, cursor);
    }

    public Scan<RelationshipScanCursor> relationshipLabelScan(int label) {
        this.assertOpen();
        return this.allStoreHolder.relationshipLabelScan(label);
    }

    public void relationshipGroups(long nodeReference, long reference, RelationshipGroupCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.relationshipGroups(nodeReference, reference, cursor);
    }

    public void relationships(long nodeReference, long reference, RelationshipTraversalCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.relationships(nodeReference, reference, cursor);
    }

    public void nodeProperties(long reference, PropertyCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.nodeProperties(reference, cursor);
    }

    public void relationshipProperties(long reference, PropertyCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.relationshipProperties(reference, cursor);
    }

    public void graphProperties(PropertyCursor cursor) {
        this.assertOpen();
        this.allStoreHolder.graphProperties(cursor);
    }

    public void futureNodeReferenceRead(long reference) {
        this.assertOpen();
        this.allStoreHolder.futureNodeReferenceRead(reference);
    }

    public void futureRelationshipsReferenceRead(long reference) {
        this.assertOpen();
        this.allStoreHolder.futureRelationshipsReferenceRead(reference);
    }

    public void futureNodePropertyReferenceRead(long reference) {
        this.assertOpen();
        this.allStoreHolder.futureNodePropertyReferenceRead(reference);
    }

    public void futureRelationshipPropertyReferenceRead(long reference) {
        this.assertOpen();
        this.allStoreHolder.futureRelationshipPropertyReferenceRead(reference);
    }

    public void nodeExplicitIndexLookup(NodeExplicitIndexCursor cursor, String index, String key, Value value) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.nodeExplicitIndexLookup(cursor, index, key, value);
    }

    public void nodeExplicitIndexQuery(NodeExplicitIndexCursor cursor, String index, Object query) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.nodeExplicitIndexQuery(cursor, index, query);
    }

    public void nodeExplicitIndexQuery(NodeExplicitIndexCursor cursor, String index, String key, Object query) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.nodeExplicitIndexQuery(cursor, index, key, query);
    }

    public void relationshipExplicitIndexGet(RelationshipExplicitIndexCursor cursor, String index, String key, Value value, long source, long target) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.relationshipExplicitIndexGet(cursor, index, key, value, source, target);
    }

    public void relationshipExplicitIndexQuery(RelationshipExplicitIndexCursor cursor, String index, Object query, long source, long target) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.relationshipExplicitIndexQuery(cursor, index, query, source, target);
    }

    public void relationshipExplicitIndexQuery(RelationshipExplicitIndexCursor cursor, String index, String key, Object query, long source, long target) throws KernelException {
        this.assertOpen();
        this.allStoreHolder.relationshipExplicitIndexQuery(cursor, index, key, query, source, target);
    }

    public CapableIndexReference index(int label, int ... properties) {
        this.assertOpen();
        return this.allStoreHolder.index(label, properties);
    }

    private void assertOpen() {
        if (!this.ktx.isOpen()) {
            throw new NotInTransactionException("The transaction has been closed.");
        }
        Optional<Status> terminationReason = this.ktx.getReasonIfTerminated();
        if (terminationReason.isPresent()) {
            throw new TransactionTerminatedException(terminationReason.get());
        }
    }
}

