/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.schema.IndexProgressor;

class NodeExplicitIndexCursor
extends IndexCursor
implements org.neo4j.internal.kernel.api.NodeExplicitIndexCursor,
IndexProgressor.ExplicitClient {
    private final Read read;
    private int expectedSize;
    private long node;
    private float score;

    NodeExplicitIndexCursor(Read read) {
        this.read = read;
    }

    @Override
    public void initialize(IndexProgressor progressor, int expectedSize) {
        super.initialize(progressor);
        this.expectedSize = expectedSize;
    }

    @Override
    public boolean acceptEntity(long reference, float score) {
        this.node = reference;
        this.score = score;
        return true;
    }

    public int expectedTotalNumberOfResults() {
        return this.expectedSize;
    }

    public float score() {
        return this.score;
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.node, cursor);
    }

    public long nodeReference() {
        return this.node;
    }

    @Override
    public void close() {
        super.close();
        this.node = -1L;
        this.score = 0.0f;
        this.expectedSize = 0;
    }
}

