/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.References;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;

class NodeCursor
extends NodeRecord
implements org.neo4j.internal.kernel.api.NodeCursor {
    private final Read read;
    private final RecordCursor<DynamicRecord> labelCursor;
    private PageCursor pageCursor;
    private long next;
    private long highMark;

    NodeCursor(Read read) {
        super(-1L);
        this.read = read;
        this.labelCursor = read.labelCursor();
    }

    void scan() {
        if (this.getId() != -1L) {
            this.reset();
        }
        if (this.pageCursor == null) {
            this.pageCursor = this.read.nodePage(0L);
        }
        this.next = 0L;
        this.highMark = this.read.nodeHighMark();
    }

    void single(long reference) {
        if (this.getId() != -1L) {
            this.reset();
        }
        if (this.pageCursor == null) {
            this.pageCursor = this.read.nodePage(reference);
        }
        this.next = reference;
        this.highMark = -1L;
    }

    public long nodeReference() {
        return this.getId();
    }

    public LabelSet labels() {
        return new Labels(NodeLabelsField.get((NodeRecord)this, this.labelCursor));
    }

    public boolean hasProperties() {
        return this.nextProp != -1L;
    }

    public void relationships(RelationshipGroupCursor cursor) {
        this.read.relationshipGroups(this.nodeReference(), this.relationshipGroupReference(), cursor);
    }

    public void allRelationships(RelationshipTraversalCursor cursor) {
        this.read.relationships(this.nodeReference(), this.allRelationshipsReference(), cursor);
    }

    public void properties(PropertyCursor cursor) {
        this.read.nodeProperties(this.propertiesReference(), cursor);
    }

    public long relationshipGroupReference() {
        return this.isDense() ? this.getNextRel() : References.setDirectFlag(this.getNextRel());
    }

    public long allRelationshipsReference() {
        return this.isDense() ? References.setGroupFlag(this.getNextRel()) : this.getNextRel();
    }

    public long propertiesReference() {
        return this.getNextProp();
    }

    public boolean next() {
        if (this.next == -1L) {
            this.reset();
            return false;
        }
        do {
            this.read.node(this, this.next++, this.pageCursor);
            if (this.next <= this.highMark) continue;
            if (this.highMark == -1L) {
                this.next = -1L;
                return this.inUse();
            }
            this.highMark = this.read.nodeHighMark();
            if (this.next <= this.highMark) continue;
            this.next = -1L;
            return this.inUse();
        } while (!this.inUse());
        return true;
    }

    public boolean shouldRetry() {
        return false;
    }

    public void close() {
        if (this.pageCursor != null) {
            this.pageCursor.close();
            this.pageCursor = null;
        }
        this.reset();
    }

    private void reset() {
        this.next = -1L;
        this.setId(-1L);
    }
}

