/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.InwardKernel;
import org.neo4j.kernel.api.txstate.ExplicitIndexTransactionState;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.Cursors;
import org.neo4j.kernel.impl.newapi.KernelSession;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;

public class NewKernel
implements Kernel {
    private final StorageEngine engine;
    private final InwardKernel kernel;
    private final Supplier<ExplicitIndexTransactionState> explicitIndexes;
    private StorageStatement statement;
    private Read read;
    private Cursors cursors;
    private volatile boolean isRunning;

    public NewKernel(StorageEngine engine, Supplier<ExplicitIndexTransactionState> explicitIndexes, InwardKernel kernel) {
        this.engine = engine;
        this.explicitIndexes = explicitIndexes;
        this.kernel = kernel;
        this.isRunning = false;
    }

    public CursorFactory cursors() {
        assert (this.isRunning) : "kernel is not running, so it is not possible to use it";
        return this.cursors;
    }

    public KernelSession beginSession(SecurityContext securityContext) {
        assert (this.isRunning) : "kernel is not running, so it is not possible to use it";
        return new KernelSession(this.engine, this.kernel, securityContext);
    }

    public void start() {
        this.statement = this.engine.storeReadLayer().newStatement();
        this.read = new AllStoreHolder(this.engine, this.statement, this.explicitIndexes);
        this.cursors = new Cursors(this.read);
        this.isRunning = true;
    }

    public void stop() {
        if (!this.isRunning) {
            throw new IllegalStateException("kernel is not running, so it is not possible to stop it");
        }
        this.statement.close();
        this.isRunning = false;
    }
}

