/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import org.neo4j.collection.primitive.PrimitiveLongResourceCollections;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;

class FusionIndexReader
implements IndexReader {
    private final IndexReader nativeReader;
    private final IndexReader luceneReader;
    private final FusionSchemaIndexProvider.Selector selector;
    private final int[] propertyKeys;

    FusionIndexReader(IndexReader nativeReader, IndexReader luceneReader, FusionSchemaIndexProvider.Selector selector, int[] propertyKeys) {
        this.nativeReader = nativeReader;
        this.luceneReader = luceneReader;
        this.selector = selector;
        this.propertyKeys = propertyKeys;
    }

    public void close() {
        try {
            this.nativeReader.close();
        }
        finally {
            this.luceneReader.close();
        }
    }

    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        return this.selector.select(this.nativeReader, this.luceneReader, propertyValues).countIndexedNodes(nodeId, propertyValues);
    }

    @Override
    public IndexSampler createSampler() {
        return new FusionIndexSampler(this.nativeReader.createSampler(), this.luceneReader.createSampler());
    }

    @Override
    public PrimitiveLongResourceIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates.length > 1) {
            return this.luceneReader.query(predicates);
        }
        if (predicates[0] instanceof IndexQuery.ExactPredicate) {
            IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicates[0];
            return this.selector.select(this.nativeReader, this.luceneReader, exactPredicate.value()).query(predicates);
        }
        if (predicates[0] instanceof IndexQuery.NumberRangePredicate) {
            return this.nativeReader.query(predicates[0]);
        }
        if (predicates[0] instanceof IndexQuery.ExistsPredicate) {
            PrimitiveLongResourceIterator nativeResult = this.nativeReader.query(predicates[0]);
            PrimitiveLongResourceIterator luceneResult = this.luceneReader.query(predicates[0]);
            return PrimitiveLongResourceCollections.concat((PrimitiveLongResourceIterator[])new PrimitiveLongResourceIterator[]{nativeResult, luceneResult});
        }
        return this.luceneReader.query(predicates);
    }

    @Override
    public void query(IndexProgressor.NodeValueClient cursor, IndexOrder indexOrder, IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates.length > 1) {
            this.luceneReader.query(cursor, indexOrder, predicates);
            return;
        }
        if (predicates[0] instanceof IndexQuery.ExactPredicate) {
            IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicates[0];
            this.selector.select(this.nativeReader, this.luceneReader, exactPredicate.value()).query(cursor, indexOrder, predicates);
            return;
        }
        if (predicates[0] instanceof IndexQuery.NumberRangePredicate) {
            this.nativeReader.query(cursor, indexOrder, predicates[0]);
            return;
        }
        if (predicates[0] instanceof IndexQuery.ExistsPredicate) {
            if (indexOrder != IndexOrder.NONE) {
                throw new UnsupportedOperationException(String.format("Tried to query index with unsupported order %s. Supported orders for query %s are %s.", indexOrder, Arrays.toString(predicates), IndexOrder.NONE));
            }
            BridgingIndexProgressor multiProgressor = new BridgingIndexProgressor(cursor, this.propertyKeys);
            cursor.initialize(multiProgressor, this.propertyKeys);
            this.nativeReader.query(multiProgressor, indexOrder, predicates[0]);
            this.luceneReader.query(multiProgressor, indexOrder, predicates[0]);
            return;
        }
        this.luceneReader.query(cursor, indexOrder, predicates);
    }

    @Override
    public boolean hasFullNumberPrecision(IndexQuery ... predicates) {
        if (predicates.length > 1) {
            return false;
        }
        IndexQuery predicate = predicates[0];
        if (predicate instanceof IndexQuery.ExactPredicate) {
            Value value = ((IndexQuery.ExactPredicate)predicate).value();
            return this.selector.select(this.nativeReader.hasFullNumberPrecision(predicates), this.luceneReader.hasFullNumberPrecision(predicates), value);
        }
        return predicates[0] instanceof IndexQuery.NumberRangePredicate && this.nativeReader.hasFullNumberPrecision(predicates);
    }

    private class BridgingIndexProgressor
    implements IndexProgressor.NodeValueClient,
    IndexProgressor {
        private final IndexProgressor.NodeValueClient client;
        private final int[] keys;
        private final Queue<IndexProgressor> progressors;
        private IndexProgressor current;

        BridgingIndexProgressor(IndexProgressor.NodeValueClient client, int[] keys) {
            this.client = client;
            this.keys = keys;
            this.progressors = new ArrayDeque<IndexProgressor>();
        }

        @Override
        public boolean next() {
            if (this.current == null) {
                this.current = this.progressors.poll();
            }
            while (this.current != null) {
                if (this.current.next()) {
                    return true;
                }
                this.current.close();
                this.current = this.progressors.poll();
            }
            return false;
        }

        @Override
        public void close() {
            this.progressors.forEach(IndexProgressor::close);
        }

        @Override
        public void initialize(IndexProgressor progressor, int[] keys) {
            this.assertKeysAlign(keys);
            this.progressors.add(progressor);
        }

        private void assertKeysAlign(int[] keys) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.keys[i] == keys[i]) continue;
                throw new UnsupportedOperationException("Can not chain multiple progressors with different key set.");
            }
        }

        @Override
        public boolean acceptNode(long reference, Value[] values) {
            return this.client.acceptNode(reference, values);
        }
    }
}

