/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexReader;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexUpdater;
import org.neo4j.kernel.impl.index.schema.fusion.FusionSchemaIndexProvider;
import org.neo4j.storageengine.api.schema.IndexReader;

class FusionIndexAccessor
implements IndexAccessor {
    private final IndexAccessor nativeAccessor;
    private final IndexAccessor luceneAccessor;
    private final FusionSchemaIndexProvider.Selector selector;
    private final long indexId;
    private final IndexDescriptor descriptor;
    private final FusionSchemaIndexProvider.DropAction dropAction;

    FusionIndexAccessor(IndexAccessor nativeAccessor, IndexAccessor luceneAccessor, FusionSchemaIndexProvider.Selector selector, long indexId, IndexDescriptor descriptor, FusionSchemaIndexProvider.DropAction dropAction) {
        this.nativeAccessor = nativeAccessor;
        this.luceneAccessor = luceneAccessor;
        this.selector = selector;
        this.indexId = indexId;
        this.descriptor = descriptor;
        this.dropAction = dropAction;
    }

    @Override
    public void drop() throws IOException {
        try {
            this.nativeAccessor.drop();
        }
        finally {
            this.luceneAccessor.drop();
        }
        this.dropAction.drop(this.indexId);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return new FusionIndexUpdater(this.nativeAccessor.newUpdater(mode), this.luceneAccessor.newUpdater(mode), this.selector);
    }

    @Override
    public void force() throws IOException {
        this.nativeAccessor.force();
        this.luceneAccessor.force();
    }

    @Override
    public void close() throws IOException {
        try {
            this.nativeAccessor.close();
        }
        finally {
            this.luceneAccessor.close();
        }
    }

    @Override
    public IndexReader newReader() {
        return new FusionIndexReader(this.nativeAccessor.newReader(), this.luceneAccessor.newReader(), this.selector, this.descriptor.schema().getPropertyIds());
    }

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        final BoundedIterable<Long> nativeAllEntries = this.nativeAccessor.newAllEntriesReader();
        final BoundedIterable<Long> luceneAllEntries = this.luceneAccessor.newAllEntriesReader();
        return new BoundedIterable<Long>(){

            @Override
            public long maxCount() {
                long nativeMaxCount = nativeAllEntries.maxCount();
                long luceneMaxCount = luceneAllEntries.maxCount();
                return nativeMaxCount == -1L || luceneMaxCount == -1L ? -1L : nativeMaxCount + luceneMaxCount;
            }

            @Override
            public void close() throws Exception {
                try {
                    nativeAllEntries.close();
                }
                finally {
                    luceneAllEntries.close();
                }
            }

            @Override
            public Iterator<Long> iterator() {
                return Iterables.concat((Iterable[])new Iterable[]{nativeAllEntries, luceneAllEntries}).iterator();
            }
        };
    }

    @Override
    public ResourceIterator<File> snapshotFiles() throws IOException {
        return Iterators.concatResourceIterators(Arrays.asList(this.nativeAccessor.snapshotFiles(), this.luceneAccessor.snapshotFiles()).iterator());
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        this.nativeAccessor.verifyDeferredConstraints(propertyAccessor);
        this.luceneAccessor.verifyDeferredConstraints(propertyAccessor);
    }
}

