/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexMeta;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;

public class PopulatingIndexProxy
implements IndexProxy {
    private final IndexMeta indexMeta;
    private final IndexPopulationJob job;

    PopulatingIndexProxy(IndexMeta indexMeta, IndexPopulationJob job) {
        this.indexMeta = indexMeta;
        this.job = job;
    }

    @Override
    public void start() {
    }

    @Override
    public IndexUpdater newUpdater(final IndexUpdateMode mode) {
        switch (mode) {
            case ONLINE: 
            case RECOVERY: {
                return new PopulatingIndexUpdater(){

                    @Override
                    public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
                        PopulatingIndexProxy.this.job.update(update);
                    }
                };
            }
        }
        return new PopulatingIndexUpdater(){

            @Override
            public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
                throw new IllegalArgumentException("Unsupported update mode: " + (Object)((Object)mode));
            }
        };
    }

    @Override
    public Future<Void> drop() {
        return this.job.cancel();
    }

    @Override
    public IndexDescriptor getDescriptor() {
        return this.indexMeta.indexDescriptor();
    }

    @Override
    public LabelSchemaDescriptor schema() {
        return this.indexMeta.indexDescriptor().schema();
    }

    @Override
    public SchemaIndexProvider.Descriptor getProviderDescriptor() {
        return this.indexMeta.providerDescriptor();
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.POPULATING;
    }

    @Override
    public IndexCapability getIndexCapability() {
        return this.indexMeta.indexCapability();
    }

    @Override
    public void force() {
    }

    @Override
    public Future<Void> close() {
        return this.job.cancel();
    }

    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        throw new IndexNotFoundKernelException("Index is still populating: " + this.job);
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException, InterruptedException {
        this.job.awaitCompletion();
        return true;
    }

    @Override
    public void activate() throws IndexActivationFailedKernelException {
        throw new IllegalStateException("Cannot activate index while it is still populating: " + this.job);
    }

    @Override
    public void validate() {
        throw new IllegalStateException("Cannot validate index while it is still populating: " + this.job);
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return Iterators.emptyResourceIterator();
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(this + " is POPULATING");
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return this.job.getPopulationProgress();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[job:" + this.job + "]";
    }

    private abstract class PopulatingIndexUpdater
    implements IndexUpdater {
        private PopulatingIndexUpdater() {
        }

        @Override
        public void close() throws IOException, IndexEntryConflictException {
        }
    }
}

