/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.stream.Stream;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorCounters;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.QueryRegistrationOperations;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.kernel.impl.util.MonotonicCounter;
import org.neo4j.resources.CpuClock;
import org.neo4j.resources.HeapAllocation;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class StackingQueryRegistrationOperations
implements QueryRegistrationOperations {
    private final MonotonicCounter lastQueryId = MonotonicCounter.newAtomicMonotonicCounter();
    private final SystemNanoClock clock;
    private final CpuClock cpuClock;
    private final HeapAllocation heapAllocation;

    public StackingQueryRegistrationOperations(SystemNanoClock clock, CpuClock cpuClock, HeapAllocation heapAllocation) {
        this.clock = clock;
        this.cpuClock = cpuClock;
        this.heapAllocation = heapAllocation;
    }

    @Override
    public Stream<ExecutingQuery> executingQueries(KernelStatement statement) {
        return statement.executingQueryList().queries();
    }

    @Override
    public void registerExecutingQuery(KernelStatement statement, ExecutingQuery executingQuery) {
        statement.startQueryExecution(executingQuery);
    }

    @Override
    public ExecutingQuery startQueryExecution(KernelStatement statement, ClientConnectionInfo clientConnection, String queryText, MapValue queryParameters) {
        long queryId = this.lastQueryId.incrementAndGet();
        Thread thread = Thread.currentThread();
        long threadId = thread.getId();
        String threadName = thread.getName();
        ExecutingQuery executingQuery = new ExecutingQuery(queryId, clientConnection, statement.username(), queryText, queryParameters, statement.getTransaction().getMetaData(), () -> statement.locks().activeLockCount(), (PageCursorCounters)statement.getPageCursorTracer(), threadId, threadName, this.clock, this.cpuClock, this.heapAllocation);
        this.registerExecutingQuery(statement, executingQuery);
        return executingQuery;
    }

    @Override
    public void unregisterExecutingQuery(KernelStatement statement, ExecutingQuery executingQuery) {
        statement.stopQueryExecution(executingQuery);
    }
}

