/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.txstate;

import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveIntCollection;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveIntVisitor;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.RelationshipDataExtractor;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class TransactionCountingStateVisitor
extends TxStateVisitor.Delegator {
    private final RelationshipDataExtractor edge = new RelationshipDataExtractor();
    private final StoreReadLayer storeLayer;
    private final StorageStatement statement;
    private final CountsRecordState counts;
    private final ReadableTransactionState txState;

    public TransactionCountingStateVisitor(TxStateVisitor next, StoreReadLayer storeLayer, StorageStatement statement, ReadableTransactionState txState, CountsRecordState counts) {
        super(next);
        this.storeLayer = storeLayer;
        this.statement = statement;
        this.txState = txState;
        this.counts = counts;
    }

    @Override
    public void visitCreatedNode(long id) {
        this.counts.incrementNodeCount(-1, 1L);
        super.visitCreatedNode(id);
    }

    @Override
    public void visitDeletedNode(long id) {
        this.counts.incrementNodeCount(-1, -1L);
        this.statement.acquireSingleNodeCursor(id).forAll(this::decrementCountForLabelsAndRelationships);
        super.visitDeletedNode(id);
    }

    private void decrementCountForLabelsAndRelationships(NodeItem node) {
        PrimitiveIntSet labelIds = node.labels();
        labelIds.visitKeys(labelId -> {
            this.counts.incrementNodeCount(labelId, -1L);
            return false;
        });
        this.storeLayer.degrees(this.statement, node, (type, out, in) -> this.updateRelationshipsCountsFromDegrees((PrimitiveIntCollection)labelIds, type, -out, -in));
    }

    @Override
    public void visitCreatedRelationship(long id, int type, long startNode, long endNode) throws ConstraintValidationException {
        this.updateRelationshipCount(startNode, type, endNode, 1);
        super.visitCreatedRelationship(id, type, startNode, endNode);
    }

    @Override
    public void visitDeletedRelationship(long id) {
        try {
            this.storeLayer.relationshipVisit(id, this.edge);
            this.updateRelationshipCount(this.edge.startNode(), this.edge.type(), this.edge.endNode(), -1);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException("Relationship being deleted should exist along with its nodes.", (Throwable)((Object)e));
        }
        super.visitDeletedRelationship(id);
    }

    @Override
    public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) throws ConstraintValidationException {
        if (!added.isEmpty() || !removed.isEmpty()) {
            for (Integer label : added) {
                this.counts.incrementNodeCount(label, 1L);
            }
            for (Integer label : removed) {
                this.counts.incrementNodeCount(label, -1L);
            }
            this.statement.acquireSingleNodeCursor(id).forAll(node -> this.storeLayer.degrees(this.statement, (NodeItem)node, (type, out, in) -> {
                added.forEach(label -> this.updateRelationshipsCountsFromDegrees(type, (int)label, out, in));
                removed.forEach(label -> this.updateRelationshipsCountsFromDegrees(type, (int)label, -out, -in));
            }));
        }
        super.visitNodeLabelChanges(id, added, removed);
    }

    private void updateRelationshipsCountsFromDegrees(PrimitiveIntCollection labels, int type, long outgoing, long incoming) {
        labels.visitKeys(label -> this.updateRelationshipsCountsFromDegrees(type, label, outgoing, incoming));
    }

    private boolean updateRelationshipsCountsFromDegrees(int type, int label, long outgoing, long incoming) {
        this.counts.incrementRelationshipCount(label, -1, -1, outgoing);
        this.counts.incrementRelationshipCount(-1, -1, label, incoming);
        this.counts.incrementRelationshipCount(label, type, -1, outgoing);
        this.counts.incrementRelationshipCount(-1, type, label, incoming);
        return false;
    }

    private void updateRelationshipCount(long startNode, int type, long endNode, int delta) {
        this.updateRelationshipsCountsFromDegrees(type, -1, (long)delta, 0L);
        this.visitLabels(startNode, (PrimitiveIntVisitor<RuntimeException>)((PrimitiveIntVisitor)labelId -> this.updateRelationshipsCountsFromDegrees(type, labelId, (long)delta, 0L)));
        this.visitLabels(endNode, (PrimitiveIntVisitor<RuntimeException>)((PrimitiveIntVisitor)labelId -> this.updateRelationshipsCountsFromDegrees(type, labelId, 0L, (long)delta)));
    }

    private void visitLabels(long nodeId, PrimitiveIntVisitor<RuntimeException> visitor) {
        this.nodeCursor(this.statement, nodeId).forAll(node -> node.labels().visitKeys(visitor));
    }

    private Cursor<NodeItem> nodeCursor(StorageStatement statement, long nodeId) {
        return this.txState.augmentSingleNodeCursor(statement.acquireSingleNodeCursor(nodeId), nodeId);
    }
}

