/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.csv.reader.Extractor;
import org.neo4j.csv.reader.Extractors;
import org.neo4j.csv.reader.Mark;
import org.neo4j.csv.reader.Readables;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.unsafe.impl.batchimport.input.DuplicateHeaderException;
import org.neo4j.unsafe.impl.batchimport.input.HeaderException;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.MissingHeaderException;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.Data;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Decorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

public class DataFactories {
    private DataFactories() {
    }

    public static <ENTITY extends InputEntity> DataFactory<ENTITY> data(final Decorator<ENTITY> decorator, final Charset charset, final File ... files) {
        if (files.length == 0) {
            throw new IllegalArgumentException("No files specified");
        }
        return config -> new Data<ENTITY>(){

            @Override
            public CharReadable stream() {
                try {
                    return Readables.files((Charset)charset, (File[])files);
                }
                catch (IOException e) {
                    throw new InputException(e.getMessage(), e);
                }
            }

            @Override
            public Decorator<ENTITY> decorator() {
                return decorator;
            }
        };
    }

    public static <ENTITY extends InputEntity> DataFactory<ENTITY> data(final Decorator<ENTITY> decorator, final Supplier<CharReadable> readable) {
        return config -> new Data<ENTITY>(){

            @Override
            public CharReadable stream() {
                return (CharReadable)readable.get();
            }

            @Override
            public Decorator<ENTITY> decorator() {
                return decorator;
            }
        };
    }

    public static Header.Factory defaultFormatNodeFileHeader() {
        return new DefaultNodeFileHeaderParser();
    }

    public static Header.Factory defaultFormatRelationshipFileHeader() {
        return new DefaultRelationshipFileHeaderParser();
    }

    @SafeVarargs
    public static Iterable<DataFactory<InputNode>> nodeData(DataFactory<InputNode> ... factories) {
        return Iterables.iterable((Object[])factories);
    }

    @SafeVarargs
    public static Iterable<DataFactory<InputRelationship>> relationshipData(DataFactory<InputRelationship> ... factories) {
        return Iterables.iterable((Object[])factories);
    }

    private static class DefaultRelationshipFileHeaderParser
    extends AbstractDefaultFileHeaderParser {
        protected DefaultRelationshipFileHeaderParser() {
            super(Type.START_ID, Type.END_ID);
        }

        @Override
        protected Header.Entry entry(int index, String name, String typeSpec, String groupName, Extractors extractors, Extractor<?> idExtractor) {
            Type type = null;
            Extractor extractor = null;
            if (typeSpec == null) {
                type = Type.PROPERTY;
                extractor = extractors.string();
            } else if (typeSpec.equalsIgnoreCase(Type.START_ID.name())) {
                type = Type.START_ID;
                extractor = idExtractor;
            } else if (typeSpec.equalsIgnoreCase(Type.END_ID.name())) {
                type = Type.END_ID;
                extractor = idExtractor;
            } else if (typeSpec.equalsIgnoreCase(Type.TYPE.name())) {
                type = Type.TYPE;
                extractor = extractors.string();
            } else {
                if (this.isRecognizedType(typeSpec)) {
                    throw new HeaderException("Unexpected relationship header type '" + typeSpec + "'");
                }
                type = Type.PROPERTY;
                extractor = extractors.valueOf(typeSpec);
            }
            return new Header.Entry(name, type, groupName, extractor);
        }
    }

    private static class DefaultNodeFileHeaderParser
    extends AbstractDefaultFileHeaderParser {
        private DefaultNodeFileHeaderParser() {
            super(new Type[0]);
        }

        @Override
        protected Header.Entry entry(int index, String name, String typeSpec, String groupName, Extractors extractors, Extractor<?> idExtractor) {
            Type type = null;
            Extractor extractor = null;
            if (typeSpec == null) {
                type = Type.PROPERTY;
                extractor = extractors.string();
            } else if (typeSpec.equalsIgnoreCase(Type.ID.name())) {
                type = Type.ID;
                extractor = idExtractor;
            } else if (typeSpec.equalsIgnoreCase(Type.LABEL.name())) {
                type = Type.LABEL;
                extractor = extractors.stringArray();
            } else {
                if (this.isRecognizedType(typeSpec)) {
                    throw new HeaderException("Unexpected node header type '" + typeSpec + "'");
                }
                type = Type.PROPERTY;
                extractor = extractors.valueOf(typeSpec);
            }
            return new Header.Entry(name, type, groupName, extractor);
        }
    }

    private static class HeaderEntrySpec {
        private final String name;
        private final String type;
        private final String groupName;

        HeaderEntrySpec(String rawHeaderField) {
            int typeIndex;
            String name = rawHeaderField;
            String type = null;
            String groupName = null;
            if (rawHeaderField != null && (typeIndex = rawHeaderField.lastIndexOf(58)) != -1) {
                name = typeIndex > 0 ? rawHeaderField.substring(0, typeIndex) : null;
                type = rawHeaderField.substring(typeIndex + 1);
                int groupNameStartIndex = type.indexOf(40);
                if (groupNameStartIndex != -1) {
                    if (!type.endsWith(")")) {
                        throw new IllegalArgumentException("Group specification in '" + rawHeaderField + "' is invalid, format expected to be 'name:TYPE(group)' where TYPE and (group) are optional");
                    }
                    groupName = type.substring(groupNameStartIndex + 1, type.length() - 1);
                    type = type.substring(0, groupNameStartIndex);
                }
            }
            this.name = name;
            this.type = type;
            this.groupName = groupName;
        }
    }

    private static abstract class AbstractDefaultFileHeaderParser
    implements Header.Factory {
        private final Type[] mandatoryTypes;

        protected AbstractDefaultFileHeaderParser(Type ... mandatoryTypes) {
            this.mandatoryTypes = mandatoryTypes;
        }

        @Override
        public Header create(CharSeeker dataSeeker, Configuration config, IdType idType) {
            try {
                Mark mark = new Mark();
                Extractors extractors = new Extractors(config.arrayDelimiter(), config.emptyQuotedStringsAsNull(), config.trimStrings());
                Extractor<?> idExtractor = idType.extractor(extractors);
                char delimiter = config.delimiter();
                ArrayList<Header.Entry> columns = new ArrayList<Header.Entry>();
                int i = 0;
                while (!mark.isEndOfLine() && dataSeeker.seek(mark, (int)delimiter)) {
                    String entryString = dataSeeker.tryExtract(mark, extractors.string()) ? (String)extractors.string().value() : null;
                    HeaderEntrySpec spec = new HeaderEntrySpec(entryString);
                    if (spec.name == null && spec.type == null || spec.type != null && spec.type.equals(Type.IGNORE.name())) {
                        columns.add(new Header.Entry(null, Type.IGNORE, null, null));
                    } else {
                        columns.add(this.entry(i, spec.name, spec.type, spec.groupName, extractors, idExtractor));
                    }
                    ++i;
                }
                Header.Entry[] entries = columns.toArray(new Header.Entry[columns.size()]);
                this.validateHeader(entries);
                return new Header(entries);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void validateHeader(Header.Entry[] entries) {
            HashMap<String, Header.Entry> properties = new HashMap<String, Header.Entry>();
            HashMap<Type, Header.Entry> singletonEntries = new HashMap<Type, Header.Entry>();
            block4: for (Header.Entry entry : entries) {
                switch (entry.type()) {
                    case PROPERTY: {
                        Header.Entry existingPropertyEntry = (Header.Entry)properties.get(entry.name());
                        if (existingPropertyEntry != null) {
                            throw new DuplicateHeaderException(existingPropertyEntry, entry);
                        }
                        properties.put(entry.name(), entry);
                        continue block4;
                    }
                    case ID: 
                    case START_ID: 
                    case END_ID: 
                    case TYPE: {
                        Header.Entry existingSingletonEntry = (Header.Entry)singletonEntries.get((Object)entry.type());
                        if (existingSingletonEntry != null) {
                            throw new DuplicateHeaderException(existingSingletonEntry, entry);
                        }
                        singletonEntries.put(entry.type(), entry);
                        continue block4;
                    }
                }
            }
            for (Type type : this.mandatoryTypes) {
                if (singletonEntries.containsKey((Object)type)) continue;
                throw new MissingHeaderException(type, entries);
            }
        }

        protected boolean isRecognizedType(String typeSpec) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(typeSpec)) continue;
                return true;
            }
            return false;
        }

        protected abstract Header.Entry entry(int var1, String var2, String var3, String var4, Extractors var5, Extractor<?> var6);
    }
}

