/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.File;
import java.io.IOException;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreFailureException;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.StoreVersion;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;

public class CountsMigrator
extends AbstractStoreMigrationParticipant {
    private static final Iterable<StoreFile> COUNTS_STORE_FILES = Iterables.iterable((Object[])new StoreFile[]{StoreFile.COUNTS_STORE_LEFT, StoreFile.COUNTS_STORE_RIGHT});
    private final Config config;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;

    public CountsMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config) {
        super("Count rebuilding");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
    }

    @Override
    public void migrate(File storeDir, File migrationDir, MigrationProgressMonitor.Section progressMonitor, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        if (this.countStoreRebuildRequired(versionToMigrateFrom)) {
            StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, migrationDir, migrationDir, COUNTS_STORE_FILES, true, null, StoreFileType.STORE);
            File neoStore = new File(storeDir, "neostore");
            long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
            try {
                this.rebuildCountsFromScratch(migrationDir, migrationDir, lastTxId, progressMonitor, versionToMigrateTo, this.pageCache, (LogProvider)NullLogProvider.getInstance());
            }
            catch (StoreFailureException e) {
                this.rebuildCountsFromScratch(storeDir, migrationDir, lastTxId, progressMonitor, versionToMigrateFrom, this.pageCache, (LogProvider)NullLogProvider.getInstance());
            }
        }
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir, String versionToUpgradeFrom, String versionToUpgradeTo) throws IOException {
        StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, storeDir, null, COUNTS_STORE_FILES, true, null, StoreFileType.values());
        StoreFile.fileOperation(FileOperation.MOVE, this.fileSystem, migrationDir, storeDir, COUNTS_STORE_FILES, true, ExistingTargetStrategy.OVERWRITE, StoreFileType.values());
    }

    @Override
    public void cleanup(File migrationDir) throws IOException {
        this.fileSystem.deleteRecursively(migrationDir);
    }

    public String toString() {
        return "Kernel Node Count Rebuilder";
    }

    boolean countStoreRebuildRequired(String versionToMigrateFrom) {
        return StandardV2_3.STORE_VERSION.equals(versionToMigrateFrom) || StandardV3_0.STORE_VERSION.equals(versionToMigrateFrom) || StoreVersion.HIGH_LIMIT_V3_0_0.versionString().equals(versionToMigrateFrom) || StoreVersion.HIGH_LIMIT_V3_0_6.versionString().equals(versionToMigrateFrom) || StoreVersion.HIGH_LIMIT_V3_1_0.versionString().equals(versionToMigrateFrom);
    }

    private void rebuildCountsFromScratch(File storeDirToReadFrom, File migrationDir, long lastTxId, MigrationProgressMonitor.Section progressMonitor, String expectedStoreVersion, PageCache pageCache, LogProvider logProvider) {
        File storeFileBase = new File(migrationDir, "neostore.counts.db");
        RecordFormats recordFormats = RecordFormatSelector.selectForVersion(expectedStoreVersion);
        StoreFactory storeFactory = new StoreFactory(storeDirToReadFrom, pageCache, this.fileSystem, recordFormats, logProvider);
        try (NeoStores neoStores = storeFactory.openNeoStores(StoreType.NODE, StoreType.RELATIONSHIP, StoreType.LABEL_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN);){
            NodeStore nodeStore = neoStores.getNodeStore();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            try (Lifespan life = new Lifespan(new Lifecycle[0]);){
                int highLabelId = (int)neoStores.getLabelTokenStore().getHighId();
                int highRelationshipTypeId = (int)neoStores.getRelationshipTypeTokenStore().getHighId();
                CountsComputer initializer = new CountsComputer(lastTxId, nodeStore, relationshipStore, highLabelId, highRelationshipTypeId, NumberArrayFactory.auto(pageCache, migrationDir, true), progressMonitor);
                life.add((Lifecycle)new CountsTracker(logProvider, this.fileSystem, pageCache, this.config, storeFileBase).setInitializer(initializer));
            }
        }
    }
}

