/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.NativeNonUniqueSchemaNumberIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexHeaderReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeUniqueSchemaNumberIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NonUniqueNumberLayout;
import org.neo4j.kernel.impl.index.schema.NumberLayout;
import org.neo4j.kernel.impl.index.schema.UniqueNumberLayout;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class NativeSchemaNumberIndexProvider
extends SchemaIndexProvider {
    public static final String KEY = "native";
    public static final SchemaIndexProvider.Descriptor NATIVE_PROVIDER_DESCRIPTOR = new SchemaIndexProvider.Descriptor("native", "1.0");
    private final PageCache pageCache;
    private final FileSystemAbstraction fs;
    private final Log log;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final boolean readOnly;

    public NativeSchemaNumberIndexProvider(PageCache pageCache, FileSystemAbstraction fs, IndexDirectoryStructure.Factory directoryStructure, LogProvider logging, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly) {
        super(NATIVE_PROVIDER_DESCRIPTOR, 0, directoryStructure);
        this.pageCache = pageCache;
        this.fs = fs;
        this.log = logging.getLog(this.getClass());
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
        this.readOnly = readOnly;
    }

    @Override
    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create populator for read only index");
        }
        File storeFile = this.nativeIndexFileFromIndexId(indexId);
        switch (descriptor.type()) {
            case GENERAL: {
                return new NativeNonUniqueSchemaNumberIndexPopulator(this.pageCache, this.fs, storeFile, new NonUniqueNumberLayout(), samplingConfig);
            }
            case UNIQUE: {
                return new NativeUniqueSchemaNumberIndexPopulator(this.pageCache, this.fs, storeFile, new UniqueNumberLayout());
            }
        }
        throw new UnsupportedOperationException("Can not create index populator of type " + (Object)((Object)descriptor.type()));
    }

    @Override
    public IndexAccessor getOnlineAccessor(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        NumberLayout layout;
        File storeFile = this.nativeIndexFileFromIndexId(indexId);
        switch (descriptor.type()) {
            case GENERAL: {
                layout = new NonUniqueNumberLayout();
                break;
            }
            case UNIQUE: {
                layout = new UniqueNumberLayout();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Can not create index accessor of type " + (Object)((Object)descriptor.type()));
            }
        }
        return new NativeSchemaNumberIndexAccessor(this.pageCache, this.fs, storeFile, layout, this.recoveryCleanupWorkCollector);
    }

    @Override
    public String getPopulationFailure(long indexId) throws IllegalStateException {
        try {
            String failureMessage = this.readPopulationFailure(indexId);
            if (failureMessage == null) {
                throw new IllegalStateException("Index " + indexId + " isn't failed");
            }
            return failureMessage;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readPopulationFailure(long indexId) throws IOException {
        NativeSchemaIndexHeaderReader headerReader = new NativeSchemaIndexHeaderReader();
        GBPTree.readHeader((PageCache)this.pageCache, (File)this.nativeIndexFileFromIndexId(indexId), (Layout)new ReadOnlyMetaNumberLayout(), (Header.Reader)headerReader);
        return headerReader.failureMessage;
    }

    @Override
    public InternalIndexState getInitialState(long indexId, IndexDescriptor descriptor) {
        try {
            NativeSchemaIndexHeaderReader headerReader = new NativeSchemaIndexHeaderReader();
            GBPTree.readHeader((PageCache)this.pageCache, (File)this.nativeIndexFileFromIndexId(indexId), (Layout)new ReadOnlyMetaNumberLayout(), (Header.Reader)headerReader);
            switch (headerReader.state) {
                case 0: {
                    return InternalIndexState.FAILED;
                }
                case 1: {
                    return InternalIndexState.ONLINE;
                }
                case 2: {
                    return InternalIndexState.POPULATING;
                }
            }
            throw new IllegalStateException("Unexpected initial state byte value " + headerReader.state);
        }
        catch (IOException e) {
            this.log.error("Failed to open index:" + indexId + ", requesting re-population.", (Throwable)e);
            return InternalIndexState.POPULATING;
        }
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    private File nativeIndexFileFromIndexId(long indexId) {
        return new File(this.directoryStructure().directoryForIndex(indexId), NativeSchemaNumberIndexProvider.indexFileName(indexId));
    }

    private static String indexFileName(long indexId) {
        return "index-" + indexId;
    }

    private class ReadOnlyMetaNumberLayout
    extends Layout.ReadOnlyMetaLayout {
        private ReadOnlyMetaNumberLayout() {
        }

        public boolean compatibleWith(long layoutIdentifier, int majorVersion, int minorVersion) {
            return layoutIdentifier == UniqueNumberLayout.IDENTIFIER && majorVersion == 0 && minorVersion == 1 || layoutIdentifier == NonUniqueNumberLayout.IDENTIFIER && majorVersion == 0 && minorVersion == 1;
        }
    }
}

