/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.updater.SwallowingIndexUpdater;
import org.neo4j.storageengine.api.schema.IndexReader;

public interface IndexAccessor
extends Closeable {
    public void drop() throws IOException;

    public IndexUpdater newUpdater(IndexUpdateMode var1);

    public void force() throws IOException;

    @Override
    public void close() throws IOException;

    public IndexReader newReader();

    public BoundedIterable<Long> newAllEntriesReader();

    public ResourceIterator<File> snapshotFiles() throws IOException;

    public void verifyDeferredConstraints(PropertyAccessor var1) throws IndexEntryConflictException, IOException;

    public static class Delegator
    implements IndexAccessor {
        private final IndexAccessor delegate;

        public Delegator(IndexAccessor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void drop() throws IOException {
            this.delegate.drop();
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return this.delegate.newUpdater(mode);
        }

        @Override
        public void force() throws IOException {
            this.delegate.force();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public IndexReader newReader() {
            return this.delegate.newReader();
        }

        @Override
        public BoundedIterable<Long> newAllEntriesReader() {
            return this.delegate.newAllEntriesReader();
        }

        @Override
        public ResourceIterator<File> snapshotFiles() throws IOException {
            return this.delegate.snapshotFiles();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
            this.delegate.verifyDeferredConstraints(propertyAccessor);
        }
    }

    public static class Adapter
    implements IndexAccessor {
        @Override
        public void drop() {
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode) {
            return SwallowingIndexUpdater.INSTANCE;
        }

        @Override
        public void force() {
        }

        @Override
        public void close() {
        }

        @Override
        public IndexReader newReader() {
            return IndexReader.EMPTY;
        }

        @Override
        public BoundedIterable<Long> newAllEntriesReader() {
            return new BoundedIterable<Long>(){

                @Override
                public long maxCount() {
                    return 0L;
                }

                @Override
                public void close() throws IOException {
                }

                @Override
                public Iterator<Long> iterator() {
                    return Collections.emptyIterator();
                }
            };
        }

        @Override
        public ResourceIterator<File> snapshotFiles() {
            return Iterators.emptyResourceIterator();
        }

        @Override
        public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
        }
    }
}

