/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;

public class PhysicalLogFileInformation
implements LogFileInformation {
    private final PhysicalLogFiles logFiles;
    private final LogHeaderCache logHeaderCache;
    private final LastEntryInLog lastEntryInLog;
    private final LogVersionToTimestamp logVersionToTimestamp;

    public PhysicalLogFileInformation(PhysicalLogFiles logFiles, LogHeaderCache logHeaderCache, LastEntryInLog lastEntryInLog, LogVersionToTimestamp logVersionToTimestamp) {
        this.logFiles = logFiles;
        this.logHeaderCache = logHeaderCache;
        this.lastEntryInLog = lastEntryInLog;
        this.logVersionToTimestamp = logVersionToTimestamp;
    }

    @Override
    public long getFirstExistingEntryId() throws IOException {
        long version = this.logFiles.getHighestLogVersion();
        long candidateFirstTx = -1L;
        while (this.logFiles.versionExists(version)) {
            candidateFirstTx = this.getFirstEntryId(version);
            --version;
        }
        return this.logFiles.hasAnyEntries(++version) ? candidateFirstTx : -1L;
    }

    @Override
    public long getFirstEntryId(long version) throws IOException {
        Long logHeader = this.logHeaderCache.getLogHeader(version);
        if (logHeader != null) {
            return logHeader + 1L;
        }
        if (this.logFiles.versionExists(version)) {
            long previousVersionLastCommittedTx = this.logFiles.extractHeader((long)version).lastCommittedTxId;
            this.logHeaderCache.putHeader(version, previousVersionLastCommittedTx);
            return previousVersionLastCommittedTx + 1L;
        }
        return -1L;
    }

    @Override
    public long getLastEntryId() {
        return this.lastEntryInLog.getLastEntryId();
    }

    @Override
    public long getFirstStartRecordTimestamp(long version) throws IOException {
        return this.logVersionToTimestamp.getTimestampForVersion(version);
    }

    public static interface LastEntryInLog {
        public long getLastEntryId();
    }

    public static interface LogVersionToTimestamp {
        public long getTimestampForVersion(long var1) throws IOException;
    }
}

