/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.Closeable;
import java.io.IOException;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.KeyFormat;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.ValueSink;

abstract class ReadableState<Key>
implements Closeable {
    ReadableState() {
    }

    protected abstract KeyFormat<Key> keyFormat();

    protected abstract Headers headers();

    protected abstract long version();

    protected abstract boolean lookup(Key var1, ValueSink var2) throws IOException;

    protected abstract DataProvider dataProvider() throws IOException;

    protected abstract int storedEntryCount();

    static <Key> ReadableState<Key> store(final KeyFormat<Key> keys, final KeyValueStoreFile store) {
        return new ReadableState<Key>(){

            @Override
            protected KeyFormat<Key> keyFormat() {
                return keys;
            }

            @Override
            protected Headers headers() {
                return store.headers();
            }

            @Override
            protected long version() {
                return keys.version(this.headers());
            }

            @Override
            protected boolean lookup(Key key, ValueSink sink) throws IOException {
                return store.scan(new KeyFormat.Searcher(keys, key), sink);
            }

            @Override
            protected DataProvider dataProvider() throws IOException {
                return store.dataProvider();
            }

            @Override
            protected int storedEntryCount() {
                return store.entryCount();
            }

            @Override
            public void close() throws IOException {
                store.close();
            }
        };
    }

    static <Key> ReadableState<Key> empty(final KeyFormat<Key> keys, final long version) {
        return new ReadableState<Key>(){

            @Override
            protected KeyFormat<Key> keyFormat() {
                return keys;
            }

            @Override
            protected Headers headers() {
                return null;
            }

            @Override
            protected long version() {
                return version;
            }

            @Override
            protected boolean lookup(Key key, ValueSink sink) throws IOException {
                return false;
            }

            @Override
            protected DataProvider dataProvider() throws IOException {
                return DataProvider.EMPTY_DATA_PROVIDER;
            }

            @Override
            protected int storedEntryCount() {
                return 0;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

