/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexAccessor;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexPopulator;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.values.storable.Value;

public class FusionSchemaIndexProvider
extends SchemaIndexProvider {
    private final SchemaIndexProvider nativeProvider;
    private final SchemaIndexProvider luceneProvider;
    private final Selector selector;

    public FusionSchemaIndexProvider(SchemaIndexProvider nativeProvider, SchemaIndexProvider luceneProvider, Selector selector) {
        super(new SchemaIndexProvider.Descriptor(nativeProvider.getProviderDescriptor().getKey() + "+" + luceneProvider.getProviderDescriptor().getKey(), nativeProvider.getProviderDescriptor().getVersion() + "+" + luceneProvider.getProviderDescriptor().getVersion()), 0);
        this.nativeProvider = nativeProvider;
        this.luceneProvider = luceneProvider;
        this.selector = selector;
    }

    @Override
    public IndexPopulator getPopulator(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
        return new FusionIndexPopulator(this.nativeProvider.getPopulator(indexId, descriptor, samplingConfig), this.luceneProvider.getPopulator(indexId, descriptor, samplingConfig), this.selector);
    }

    @Override
    public IndexAccessor getOnlineAccessor(long indexId, IndexDescriptor descriptor, IndexSamplingConfig samplingConfig) throws IOException {
        return new FusionIndexAccessor(this.nativeProvider.getOnlineAccessor(indexId, descriptor, samplingConfig), this.luceneProvider.getOnlineAccessor(indexId, descriptor, samplingConfig), this.selector);
    }

    @Override
    public String getPopulationFailure(long indexId) throws IllegalStateException {
        String nativeFailure = this.nativeProvider.getPopulationFailure(indexId);
        String luceneFailure = this.luceneProvider.getPopulationFailure(indexId);
        if (nativeFailure != null) {
            return luceneFailure == null ? nativeFailure : nativeFailure + " and " + luceneFailure;
        }
        return luceneFailure;
    }

    @Override
    public InternalIndexState getInitialState(long indexId, IndexDescriptor descriptor) {
        InternalIndexState luceneState;
        InternalIndexState nativeState = this.nativeProvider.getInitialState(indexId, descriptor);
        if (nativeState != (luceneState = this.luceneProvider.getInitialState(indexId, descriptor))) {
            throw new IllegalStateException(String.format("Internal providers answer with different state native:%s, lucene:%s", new Object[]{nativeState, luceneState}));
        }
        return nativeState;
    }

    @Override
    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return StoreMigrationParticipant.NOT_PARTICIPATING;
    }

    static IndexSample combineSamples(IndexSample first, IndexSample other) {
        return new IndexSample(first.indexSize() + other.indexSize(), first.uniqueValues() + other.uniqueValues(), first.sampleSize() + other.sampleSize());
    }

    public static interface Selector {
        public <T> T select(T var1, T var2, Value ... var3);
    }
}

