/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.collection.primitive.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.LegacyIndexHits;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.builtinprocs.IndexProcedures;
import org.neo4j.kernel.builtinprocs.SchemaProcedure;
import org.neo4j.kernel.impl.api.TokenAccess;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class BuiltInProcedures {
    @Context
    public KernelTransaction tx;
    @Context
    public DependencyResolver resolver;
    @Context
    public GraphDatabaseAPI graphDatabaseAPI;

    @Description(value="List all labels in the database.")
    @Procedure(name="db.labels", mode=Mode.READ)
    public Stream<LabelResult> listLabels() {
        try (Statement statement = this.tx.acquireStatement();){
            Stream stream = TokenAccess.LABELS.inUse(statement).map(x$0 -> new LabelResult((Label)x$0)).stream();
            return stream;
        }
    }

    @Description(value="List all property keys in the database.")
    @Procedure(name="db.propertyKeys", mode=Mode.READ)
    public Stream<PropertyKeyResult> listPropertyKeys() {
        try (Statement statement = this.tx.acquireStatement();){
            Stream stream = TokenAccess.PROPERTY_KEYS.inUse(statement).map(x$0 -> new PropertyKeyResult((String)x$0)).stream();
            return stream;
        }
    }

    @Description(value="List all relationship types in the database.")
    @Procedure(name="db.relationshipTypes", mode=Mode.READ)
    public Stream<RelationshipTypeResult> listRelationshipTypes() {
        try (Statement statement = this.tx.acquireStatement();){
            Stream stream = TokenAccess.RELATIONSHIP_TYPES.inUse(statement).map(x$0 -> new RelationshipTypeResult((RelationshipType)x$0)).stream();
            return stream;
        }
    }

    @Description(value="List all indexes in the database.")
    @Procedure(name="db.indexes", mode=Mode.READ)
    public Stream<IndexResult> listIndexes() throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations operations = statement.readOperations();
            StatementTokenNameLookup tokens = new StatementTokenNameLookup(operations);
            List indexes = Iterators.asList(operations.indexesGetAll());
            indexes.sort(Comparator.comparing(a -> a.userDescription(tokens)));
            ArrayList<IndexResult> result = new ArrayList<IndexResult>();
            for (IndexDescriptor index : indexes) {
                try {
                    String type = index.type() == IndexDescriptor.Type.UNIQUE ? IndexType.NODE_UNIQUE_PROPERTY.typeName() : IndexType.NODE_LABEL_PROPERTY.typeName();
                    result.add(new IndexResult("INDEX ON " + index.schema().userDescription(tokens), operations.indexGetState(index).toString(), type));
                }
                catch (IndexNotFoundKernelException e) {
                    throw new ProcedureException((Status)Status.Schema.IndexNotFound, (Throwable)e, "No index on ", index.userDescription(tokens));
                }
            }
            Stream stream = result.stream();
            return stream;
        }
    }

    @Description(value="Wait for an index to come online (for example: CALL db.awaitIndex(\":Person(name)\")).")
    @Procedure(name="db.awaitIndex", mode=Mode.READ)
    public void awaitIndex(@Name(value="index") String index, @Name(value="timeOutSeconds", defaultValue="300") long timeout) throws ProcedureException {
        try (IndexProcedures indexProcedures = this.indexProcedures();){
            indexProcedures.awaitIndex(index, timeout, TimeUnit.SECONDS);
        }
    }

    @Description(value="Wait for all indexes to come online (for example: CALL db.awaitIndexes(\"500\")).")
    @Procedure(name="db.awaitIndexes", mode=Mode.READ)
    public void awaitIndexes(@Name(value="timeOutSeconds", defaultValue="300") long timeout) throws ProcedureException {
        this.graphDatabaseAPI.schema().awaitIndexesOnline(timeout, TimeUnit.SECONDS);
    }

    @Description(value="Schedule resampling of an index (for example: CALL db.resampleIndex(\":Person(name)\")).")
    @Procedure(name="db.resampleIndex", mode=Mode.READ)
    public void resampleIndex(@Name(value="index") String index) throws ProcedureException {
        try (IndexProcedures indexProcedures = this.indexProcedures();){
            indexProcedures.resampleIndex(index);
        }
    }

    @Description(value="Schedule resampling of all outdated indexes.")
    @Procedure(name="db.resampleOutdatedIndexes", mode=Mode.READ)
    public void resampleOutdatedIndexes() {
        try (IndexProcedures indexProcedures = this.indexProcedures();){
            indexProcedures.resampleOutdatedIndexes();
        }
    }

    @Description(value="Show the schema of the data.")
    @Procedure(name="db.schema", mode=Mode.READ)
    public Stream<SchemaProcedure.GraphResult> metaGraph() throws ProcedureException {
        return Stream.of(new SchemaProcedure(this.graphDatabaseAPI, this.tx).buildSchemaGraph());
    }

    @Description(value="List all constraints in the database.")
    @Procedure(name="db.constraints", mode=Mode.READ)
    public Stream<ConstraintResult> listConstraints() {
        Statement statement = this.tx.acquireStatement();
        ReadOperations operations = statement.readOperations();
        StatementTokenNameLookup tokens = new StatementTokenNameLookup(operations);
        return (Stream)Iterators.asList(operations.constraintsGetAll()).stream().map(constraint -> constraint.prettyPrint(tokens)).sorted().map(x$0 -> new ConstraintResult((String)x$0)).onClose(() -> ((Statement)statement).close());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Get node from manual index. Replaces `START n=node:nodes(key = 'A')`")
    @Procedure(name="db.nodeManualIndexSeek", mode=Mode.READ)
    public Stream<NodeResult> nodeManualIndexSeek(@Name(value="indexName") String legacyIndexName, @Name(value="key") String key, @Name(value="value") Object value) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            LegacyIndexHits hits = readOperations.nodeLegacyIndexGet(legacyIndexName, key, value);
            Stream<NodeResult> stream = this.toStream(hits, id -> new NodeResult(this.graphDatabaseAPI.getNodeById((long)id)));
            return stream;
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.LegacyIndex.LegacyIndexNotFound, "Node index %s not found", legacyIndexName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Search nodes from manual index. Replaces `START n=node:nodes('key:foo*')`")
    @Procedure(name="db.nodeManualIndexSearch", mode=Mode.READ)
    public Stream<NodeResult> nodeManualIndexSearch(@Name(value="indexName") String manualIndexName, @Name(value="query") Object query) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            LegacyIndexHits hits = readOperations.nodeLegacyIndexQuery(manualIndexName, query);
            Stream<NodeResult> stream = this.toStream(hits, id -> new NodeResult(this.graphDatabaseAPI.getNodeById((long)id)));
            return stream;
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.LegacyIndex.LegacyIndexNotFound, "Node index %s not found", manualIndexName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Get relationship from manual index. Replaces `START r=relationship:relIndex(key = 'A')`")
    @Procedure(name="db.relationshipManualIndexSeek", mode=Mode.READ)
    public Stream<RelationshipResult> relationshipManualIndexSeek(@Name(value="indexName") String manualIndexName, @Name(value="key") String key, @Name(value="value") Object value) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            LegacyIndexHits hits = readOperations.relationshipLegacyIndexGet(manualIndexName, key, value, -1L, -1L);
            Stream<RelationshipResult> stream = this.toStream(hits, id -> new RelationshipResult(this.graphDatabaseAPI.getRelationshipById((long)id)));
            return stream;
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.LegacyIndex.LegacyIndexNotFound, "Relationship index %s not found", manualIndexName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Description(value="Search relationship from manual index. Replaces `START r=relationship:relIndex('key:foo*')`")
    @Procedure(name="db.relationshipManualIndexSearch", mode=Mode.READ)
    public Stream<RelationshipResult> relationshipManualIndexSearch(@Name(value="indexName") String manualIndexName, @Name(value="query") Object query) throws ProcedureException {
        try (Statement statement = this.tx.acquireStatement();){
            ReadOperations readOperations = statement.readOperations();
            LegacyIndexHits hits = readOperations.relationshipLegacyIndexQuery(manualIndexName, query, -1L, -1L);
            Stream<RelationshipResult> stream = this.toStream(hits, id -> new RelationshipResult(this.graphDatabaseAPI.getRelationshipById((long)id)));
            return stream;
        }
        catch (LegacyIndexNotFoundKernelException e) {
            throw new ProcedureException((Status)Status.LegacyIndex.LegacyIndexNotFound, "Relationship index %s not found", manualIndexName);
        }
    }

    private <T> Stream<T> toStream(final PrimitiveLongResourceIterator iterator, final Function<Long, T> mapper) {
        Iterator it = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return mapper.apply(iterator.next());
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    private IndexProcedures indexProcedures() {
        return new IndexProcedures(this.tx, (IndexingService)this.resolver.resolveDependency(IndexingService.class));
    }

    private static enum IndexType {
        NODE_LABEL_PROPERTY("node_label_property"),
        NODE_UNIQUE_PROPERTY("node_unique_property");

        private final String typeName;

        private IndexType(String typeName) {
            this.typeName = typeName;
        }

        public String typeName() {
            return this.typeName;
        }
    }

    public class RelationshipResult {
        public final Relationship relationship;

        public RelationshipResult(Relationship relationship) {
            this.relationship = relationship;
        }
    }

    public class NodeResult {
        public final Node node;

        public NodeResult(Node node) {
            this.node = node;
        }
    }

    public class ConstraintResult {
        public final String description;

        private ConstraintResult(String description) {
            this.description = description;
        }
    }

    public class IndexResult {
        public final String description;
        public final String state;
        public final String type;

        private IndexResult(String description, String state, String type) {
            this.description = description;
            this.state = state;
            this.type = type;
        }
    }

    public class RelationshipTypeResult {
        public final String relationshipType;

        private RelationshipTypeResult(RelationshipType relationshipType) {
            this.relationshipType = relationshipType.name();
        }
    }

    public class PropertyKeyResult {
        public final String propertyKey;

        private PropertyKeyResult(String propertyKey) {
            this.propertyKey = propertyKey;
        }
    }

    public class LabelResult {
        public final String label;

        private LabelResult(Label label) {
            this.label = label.name();
        }
    }
}

