/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityReader;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;

public class InputNodeReader
extends InputEntityReader<InputNode> {
    public InputNodeReader(StoreChannel channel, StoreChannel header, int bufferSize, Runnable closeAction, int maxNbrOfProcessors) throws IOException {
        super(channel, header, bufferSize, closeAction, maxNbrOfProcessors);
    }

    @Override
    protected InputNode readNextOrNull(Object properties, InputEntityReader.ProcessorState state) throws IOException {
        String[] labels;
        ReadableClosablePositionAwareChannel channel = state.batchChannel;
        Group group = this.readGroup(0, state);
        Object id = this.readValue(channel);
        byte labelsMode = channel.get();
        if (labelsMode == 3) {
            labels = Long.valueOf(channel.getLong());
        } else if (labelsMode == 0) {
            labels = state.previousLabels;
        } else {
            String[] newLabels = (String[])state.previousLabels.clone();
            int cursor = newLabels.length;
            while (labelsMode != 0) {
                switch (labelsMode) {
                    case 1: {
                        this.remove((String)this.readToken((byte)1, channel), newLabels, cursor--);
                        break;
                    }
                    case 2: {
                        String[] stringArray = this.ensureRoomForOneMore(newLabels, cursor);
                        newLabels = stringArray;
                        stringArray[cursor++] = (String)this.readToken((byte)1, channel);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized label mode " + labelsMode);
                    }
                }
                labelsMode = channel.get();
            }
            state.previousLabels = cursor == newLabels.length ? newLabels : Arrays.copyOf(newLabels, cursor);
            labels = state.previousLabels;
        }
        return new InputNode(this.sourceDescription(), this.lineNumber(), this.position(), group, id, properties.getClass().isArray() ? (Object[])properties : InputEntity.NO_PROPERTIES, properties.getClass().isArray() ? null : (Long)properties, labels.getClass().isArray() ? labels : InputEntity.NO_LABELS, labels.getClass().isArray() ? null : (Long)labels);
    }

    private String[] ensureRoomForOneMore(String[] labels, int cursor) {
        return cursor >= labels.length ? Arrays.copyOf(labels, cursor + 1) : labels;
    }

    private void remove(String item, String[] from, int cursor) {
        for (int i = 0; i < cursor; ++i) {
            if (!item.equals(from[i])) continue;
            from[i] = from[cursor - 1];
            from[cursor - 1] = null;
            return;
        }
        throw new IllegalArgumentException("Diff said to remove " + item + " from " + Arrays.toString(from) + ", but it didn't contain it");
    }
}

