/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.util.Iterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Visitable;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureVisitor;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GraphDbStructureGuide
implements Visitable<DbStructureVisitor> {
    private static RelationshipType WILDCARD_REL_TYPE = new RelationshipType(){

        public String name() {
            return "";
        }
    };
    private final GraphDatabaseService db;
    private final ThreadToStatementContextBridge bridge;

    public GraphDbStructureGuide(GraphDatabaseService graph) {
        this.db = graph;
        DependencyResolver dependencies = ((GraphDatabaseAPI)graph).getDependencyResolver();
        this.bridge = (ThreadToStatementContextBridge)dependencies.resolveDependency(ThreadToStatementContextBridge.class);
    }

    public void accept(DbStructureVisitor visitor) {
        try (Transaction tx = this.db.beginTx();){
            try (Statement statement = this.bridge.get();){
                this.showStructure(statement, visitor);
            }
            tx.success();
        }
    }

    private void showStructure(Statement statement, DbStructureVisitor visitor) {
        ReadOperations read = statement.readOperations();
        try {
            this.showTokens(visitor, read);
            this.showSchema(visitor, read);
            this.showStatistics(visitor, read);
        }
        catch (KernelException e) {
            throw new IllegalStateException("Kernel exception when traversing database schema structure and statistics. This is not expected to happen.", e);
        }
    }

    private void showTokens(DbStructureVisitor visitor, ReadOperations read) {
        this.showLabels(read, visitor);
        this.showPropertyKeys(read, visitor);
        this.showRelTypes(read, visitor);
    }

    private void showLabels(ReadOperations read, DbStructureVisitor visitor) {
        for (Label label : this.db.getAllLabels()) {
            int labelId = read.labelGetForName(label.name());
            visitor.visitLabel(labelId, label.name());
        }
    }

    private void showPropertyKeys(ReadOperations read, DbStructureVisitor visitor) {
        for (String propertyKeyName : this.db.getAllPropertyKeys()) {
            int propertyKeyId = read.propertyKeyGetForName(propertyKeyName);
            visitor.visitPropertyKey(propertyKeyId, propertyKeyName);
        }
    }

    private void showRelTypes(ReadOperations read, DbStructureVisitor visitor) {
        for (RelationshipType relType : this.db.getAllRelationshipTypes()) {
            int relTypeId = read.relationshipTypeGetForName(relType.name());
            visitor.visitRelationshipType(relTypeId, relType.name());
        }
    }

    private void showSchema(DbStructureVisitor visitor, ReadOperations read) throws IndexNotFoundKernelException {
        StatementTokenNameLookup nameLookup = new StatementTokenNameLookup(read);
        this.showIndices(visitor, read, nameLookup);
        this.showUniqueConstraints(visitor, read, nameLookup);
    }

    private void showIndices(DbStructureVisitor visitor, ReadOperations read, TokenNameLookup nameLookup) throws IndexNotFoundKernelException {
        for (IndexDescriptor descriptor : Iterators.loop(IndexDescriptor.sortByType(read.indexesGetAll()))) {
            String userDescription = descriptor.schema().userDescription(nameLookup);
            double uniqueValuesPercentage = read.indexUniqueValuesSelectivity(descriptor);
            long size = read.indexSize(descriptor);
            visitor.visitIndex(descriptor, userDescription, uniqueValuesPercentage, size);
        }
    }

    private void showUniqueConstraints(DbStructureVisitor visitor, ReadOperations read, TokenNameLookup nameLookup) {
        Iterator<ConstraintDescriptor> constraints = read.constraintsGetAll();
        while (constraints.hasNext()) {
            ConstraintDescriptor existenceConstraint;
            ConstraintDescriptor constraint = constraints.next();
            String userDescription = constraint.prettyPrint(nameLookup);
            if (constraint instanceof UniquenessConstraintDescriptor) {
                visitor.visitUniqueConstraint((UniquenessConstraintDescriptor)constraint, userDescription);
                continue;
            }
            if (constraint instanceof NodeExistenceConstraintDescriptor) {
                existenceConstraint = (NodeExistenceConstraintDescriptor)constraint;
                visitor.visitNodePropertyExistenceConstraint((NodeExistenceConstraintDescriptor)existenceConstraint, userDescription);
                continue;
            }
            if (constraint instanceof RelExistenceConstraintDescriptor) {
                existenceConstraint = (RelExistenceConstraintDescriptor)constraint;
                visitor.visitRelationshipPropertyExistenceConstraint((RelExistenceConstraintDescriptor)existenceConstraint, userDescription);
                continue;
            }
            throw new IllegalArgumentException("Unknown constraint type: " + constraint.getClass() + ", constraint: " + constraint);
        }
    }

    private void showStatistics(DbStructureVisitor visitor, ReadOperations read) {
        this.showNodeCounts(read, visitor);
        this.showRelCounts(read, visitor);
    }

    private void showNodeCounts(ReadOperations read, DbStructureVisitor visitor) {
        visitor.visitAllNodesCount(read.countsForNode(-1));
        for (Label label : this.db.getAllLabels()) {
            int labelId = read.labelGetForName(label.name());
            visitor.visitNodeCount(labelId, label.name(), read.countsForNode(labelId));
        }
    }

    private void showRelCounts(ReadOperations read, DbStructureVisitor visitor) {
        this.noSide(read, visitor, WILDCARD_REL_TYPE, -1);
        for (Label label : this.db.getAllLabels()) {
            int labelId = read.labelGetForName(label.name());
            this.leftSide(read, visitor, label, labelId, WILDCARD_REL_TYPE, -1);
            this.rightSide(read, visitor, label, labelId, WILDCARD_REL_TYPE, -1);
        }
        for (RelationshipType relType : this.db.getAllRelationshipTypes()) {
            int relTypeId = read.relationshipTypeGetForName(relType.name());
            this.noSide(read, visitor, relType, relTypeId);
            for (Label label : this.db.getAllLabels()) {
                int labelId = read.labelGetForName(label.name());
                this.leftSide(read, visitor, label, labelId, relType, relTypeId);
                this.rightSide(read, visitor, label, labelId, relType, relTypeId);
            }
        }
    }

    private void noSide(ReadOperations read, DbStructureVisitor visitor, RelationshipType relType, int relTypeId) {
        String userDescription = String.format("MATCH ()-[%s]->() RETURN count(*)", this.colon(relType.name()));
        long amount = read.countsForRelationship(-1, relTypeId, -1);
        visitor.visitRelCount(-1, relTypeId, -1, userDescription, amount);
    }

    private void leftSide(ReadOperations read, DbStructureVisitor visitor, Label label, int labelId, RelationshipType relType, int relTypeId) {
        String userDescription = String.format("MATCH (%s)-[%s]->() RETURN count(*)", this.colon(label.name()), this.colon(relType.name()));
        long amount = read.countsForRelationship(labelId, relTypeId, -1);
        visitor.visitRelCount(labelId, relTypeId, -1, userDescription, amount);
    }

    private void rightSide(ReadOperations read, DbStructureVisitor visitor, Label label, int labelId, RelationshipType relType, int relTypeId) {
        String userDescription = String.format("MATCH ()-[%s]->(%s) RETURN count(*)", this.colon(relType.name()), this.colon(label.name()));
        long amount = read.countsForRelationship(-1, relTypeId, labelId);
        visitor.visitRelCount(-1, relTypeId, labelId, userDescription, amount);
    }

    private String colon(String name) {
        return name.length() == 0 ? name : ":" + name;
    }
}

