/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.factory;

import java.io.File;
import java.time.Clock;
import java.util.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.legacyindex.AutoIndexing;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.builtinprocs.SpecialBuiltInProcedures;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.guard.TimeoutGuard;
import org.neo4j.kernel.impl.api.NonTransactionalTokenNameLookup;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.dbms.NonTransactionalDbmsOperations;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.legacyindex.InternalAutoIndexing;
import org.neo4j.kernel.impl.cache.MonitorGc;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.ProcedureConfig;
import org.neo4j.kernel.impl.proc.ProcedureGDSFactory;
import org.neo4j.kernel.impl.proc.ProcedureTransactionProvider;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.proc.TerminationGuardProvider;
import org.neo4j.kernel.impl.proc.TypeMappers;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.KernelEventHandlers;
import org.neo4j.kernel.internal.TransactionEventHandlers;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.procedure.ProcedureTransaction;
import org.neo4j.procedure.TerminationGuard;

public class DataSourceModule {
    public final ThreadToStatementContextBridge threadToTransactionBridge;
    public final NodeManager nodeManager;
    public final NeoStoreDataSource neoStoreDataSource;
    public final Supplier<KernelAPI> kernelAPI;
    public final Supplier<QueryExecutionEngine> queryExecutor;
    public final KernelEventHandlers kernelEventHandlers;
    public final TransactionEventHandlers transactionEventHandlers;
    public final Supplier<StoreId> storeId;
    public final AutoIndexing autoIndexing;
    public final Guard guard;

    public DataSourceModule(PlatformModule platformModule, EditionModule editionModule, Supplier<QueryExecutionEngine> queryExecutionEngineSupplier) {
        Dependencies deps = platformModule.dependencies;
        Config config = platformModule.config;
        LogService logging = platformModule.logging;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        DataSourceManager dataSourceManager = platformModule.dataSourceManager;
        LifeSupport life = platformModule.life;
        GraphDatabaseFacade graphDatabaseFacade = platformModule.graphDatabaseFacade;
        RelationshipTypeTokenHolder relationshipTypeTokenHolder = editionModule.relationshipTypeTokenHolder;
        File storeDir = platformModule.storeDir;
        DiagnosticsManager diagnosticsManager = platformModule.diagnosticsManager;
        this.queryExecutor = queryExecutionEngineSupplier;
        this.threadToTransactionBridge = (ThreadToStatementContextBridge)deps.satisfyDependency(life.add((Lifecycle)new ThreadToStatementContextBridge()));
        this.nodeManager = deps.satisfyDependency(new NodeManager(graphDatabaseFacade, this.threadToTransactionBridge, relationshipTypeTokenHolder));
        NodeProxy.NodeActions nodeActions = deps.satisfyDependency(this.createNodeActions(graphDatabaseFacade, this.threadToTransactionBridge, this.nodeManager));
        RelationshipProxy.RelationshipActions relationshipActions = deps.satisfyDependency(this.createRelationshipActions(graphDatabaseFacade, this.threadToTransactionBridge, this.nodeManager, relationshipTypeTokenHolder));
        this.transactionEventHandlers = new TransactionEventHandlers(nodeActions, relationshipActions);
        diagnosticsManager.prependProvider(config);
        life.add((Lifecycle)platformModule.kernelExtensions);
        PageCache pageCache = platformModule.pageCache;
        StartupStatisticsProvider startupStatistics = deps.satisfyDependency(new StartupStatisticsProvider());
        SchemaWriteGuard schemaWriteGuard = deps.satisfyDependency(editionModule.schemaWriteGuard);
        this.guard = this.createGuard(deps, (Clock)platformModule.clock, logging);
        this.kernelEventHandlers = new KernelEventHandlers(logging.getInternalLog(KernelEventHandlers.class));
        DatabasePanicEventGenerator databasePanicEventGenerator = deps.satisfyDependency(new DatabasePanicEventGenerator(this.kernelEventHandlers));
        DatabaseHealth databaseHealth = deps.satisfyDependency(new DatabaseHealth(databasePanicEventGenerator, logging.getInternalLog(DatabaseHealth.class)));
        this.autoIndexing = new InternalAutoIndexing(platformModule.config, editionModule.propertyKeyTokenHolder);
        Procedures procedures = this.setupProcedures(platformModule, editionModule);
        deps.satisfyDependency(new NonTransactionalDbmsOperations(procedures));
        editionModule.setupSecurityModule(platformModule, procedures);
        NonTransactionalTokenNameLookup tokenNameLookup = new NonTransactionalTokenNameLookup(editionModule.labelTokenHolder, editionModule.relationshipTypeTokenHolder, editionModule.propertyKeyTokenHolder);
        this.neoStoreDataSource = deps.satisfyDependency(new NeoStoreDataSource(storeDir, config, editionModule.idGeneratorFactory, editionModule.eligibleForIdReuse, editionModule.idTypeConfigurationProvider, logging, platformModule.jobScheduler, tokenNameLookup, (DependencyResolver)deps, editionModule.propertyKeyTokenHolder, editionModule.labelTokenHolder, relationshipTypeTokenHolder, editionModule.statementLocksFactory, schemaWriteGuard, this.transactionEventHandlers, platformModule.monitors.newMonitor(IndexingService.Monitor.class, new String[0]), fileSystem, platformModule.transactionMonitor, databaseHealth, platformModule.monitors.newMonitor(PhysicalLogFile.Monitor.class, new String[0]), editionModule.headerInformationFactory, startupStatistics, this.guard, editionModule.commitProcessFactory, this.autoIndexing, pageCache, editionModule.constraintSemantics, platformModule.monitors, platformModule.tracers, procedures, editionModule.ioLimiter, platformModule.availabilityGuard, platformModule.clock, editionModule.accessCapability, platformModule.storeCopyCheckPointMutex, platformModule.recoveryCleanupWorkCollector));
        dataSourceManager.register(this.neoStoreDataSource);
        life.add((Lifecycle)new MonitorGc(config, logging.getInternalLog(MonitorGc.class)));
        life.add((Lifecycle)this.nodeManager);
        life.add((Lifecycle)new DatabaseAvailability(platformModule.availabilityGuard, platformModule.transactionMonitor, config.get(GraphDatabaseSettings.shutdown_transaction_end_timeout)));
        life.add((Lifecycle)new StartupWaiter(platformModule.availabilityGuard, editionModule.transactionStartTimeout));
        life.add((Lifecycle)this.kernelEventHandlers);
        this.storeId = this.neoStoreDataSource::getStoreId;
        this.kernelAPI = this.neoStoreDataSource::getKernel;
        ProcedureGDSFactory gdsFactory = new ProcedureGDSFactory(platformModule, this, (DependencyResolver)deps, editionModule.coreAPIAvailabilityGuard);
        procedures.registerComponent(GraphDatabaseService.class, gdsFactory::apply, true);
    }

    protected RelationshipProxy.RelationshipActions createRelationshipActions(final GraphDatabaseService graphDatabaseService, final ThreadToStatementContextBridge threadToStatementContextBridge, final NodeManager nodeManager, final RelationshipTypeTokenHolder relationshipTypeTokenHolder) {
        return new RelationshipProxy.RelationshipActions(){

            @Override
            public GraphDatabaseService getGraphDatabaseService() {
                return graphDatabaseService;
            }

            @Override
            public void failTransaction() {
                threadToStatementContextBridge.getKernelTransactionBoundToThisThread(true).failure();
            }

            @Override
            public void assertInUnterminatedTransaction() {
                threadToStatementContextBridge.assertInUnterminatedTransaction();
            }

            @Override
            public Statement statement() {
                return threadToStatementContextBridge.get();
            }

            @Override
            public Node newNodeProxy(long nodeId) {
                return nodeManager.newNodeProxyById(nodeId);
            }

            @Override
            public RelationshipType getRelationshipTypeById(int type) {
                try {
                    return (RelationshipType)relationshipTypeTokenHolder.getTokenById(type);
                }
                catch (TokenNotFoundException e) {
                    throw new NotFoundException((Throwable)e);
                }
            }
        };
    }

    protected NodeProxy.NodeActions createNodeActions(final GraphDatabaseService graphDatabaseService, final ThreadToStatementContextBridge threadToStatementContextBridge, final NodeManager nodeManager) {
        return new NodeProxy.NodeActions(){

            @Override
            public Statement statement() {
                return threadToStatementContextBridge.get();
            }

            @Override
            public GraphDatabaseService getGraphDatabase() {
                return graphDatabaseService;
            }

            @Override
            public void assertInUnterminatedTransaction() {
                threadToStatementContextBridge.assertInUnterminatedTransaction();
            }

            @Override
            public void failTransaction() {
                threadToStatementContextBridge.getKernelTransactionBoundToThisThread(true).failure();
            }

            @Override
            public Relationship newRelationshipProxy(long id, long startNodeId, int typeId, long endNodeId) {
                return nodeManager.newRelationshipProxy(id, startNodeId, typeId, endNodeId);
            }
        };
    }

    private Guard createGuard(Dependencies deps, Clock clock, LogService logging) {
        TimeoutGuard guard = this.createGuard(clock, logging);
        deps.satisfyDependency(guard);
        return guard;
    }

    protected TimeoutGuard createGuard(Clock clock, LogService logging) {
        return new TimeoutGuard(clock, logging.getInternalLog(TimeoutGuard.class));
    }

    private Procedures setupProcedures(PlatformModule platform, EditionModule editionModule) {
        File pluginDir = platform.config.get(GraphDatabaseSettings.plugin_dir);
        Log internalLog = platform.logging.getInternalLog(Procedures.class);
        Procedures procedures = new Procedures(new SpecialBuiltInProcedures(Version.getNeo4jVersion(), platform.databaseInfo.edition.toString()), pluginDir, internalLog, new ProcedureConfig(platform.config));
        platform.life.add((Lifecycle)procedures);
        platform.dependencies.satisfyDependency(procedures);
        procedures.registerType(Node.class, new TypeMappers.SimpleConverter(Neo4jTypes.NTNode, Node.class));
        procedures.registerType(Relationship.class, new TypeMappers.SimpleConverter(Neo4jTypes.NTRelationship, Relationship.class));
        procedures.registerType(Path.class, new TypeMappers.SimpleConverter(Neo4jTypes.NTPath, Path.class));
        procedures.registerType(Geometry.class, new TypeMappers.SimpleConverter(Neo4jTypes.NTGeometry, Geometry.class));
        procedures.registerType(Point.class, new TypeMappers.SimpleConverter(Neo4jTypes.NTPoint, Point.class));
        Log proceduresLog = platform.logging.getUserLog(Procedures.class);
        procedures.registerComponent(Log.class, ctx -> proceduresLog, true);
        Guard guard = (Guard)platform.dependencies.resolveDependency(Guard.class);
        procedures.registerComponent(ProcedureTransaction.class, new ProcedureTransactionProvider(), true);
        procedures.registerComponent(TerminationGuard.class, new TerminationGuardProvider(guard), true);
        procedures.registerComponent(DependencyResolver.class, ctx -> platform.dependencies, false);
        procedures.registerComponent(KernelTransaction.class, ctx -> ctx.get(Context.KERNEL_TRANSACTION), false);
        procedures.registerComponent(GraphDatabaseAPI.class, ctx -> platform.graphDatabaseFacade, false);
        procedures.registerComponent(SecurityContext.class, ctx -> ctx.get(Context.SECURITY_CONTEXT), true);
        try {
            editionModule.registerProcedures(procedures);
        }
        catch (KernelException e) {
            internalLog.error("Failed to register built-in edition procedures at start up: " + e.getMessage());
        }
        return procedures;
    }

    private static class StartupWaiter
    extends LifecycleAdapter {
        private final AvailabilityGuard availabilityGuard;
        private final long timeout;

        StartupWaiter(AvailabilityGuard availabilityGuard, long timeout) {
            this.availabilityGuard = availabilityGuard;
            this.timeout = timeout;
        }

        public void start() throws Throwable {
            this.availabilityGuard.isAvailable(this.timeout);
        }
    }
}

