/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultiPopulatorFactory;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingControllerFactory;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;

public class IndexingServiceFactory {
    private IndexingServiceFactory() {
    }

    public static IndexingService createIndexingService(Config config, JobScheduler scheduler, SchemaIndexProviderMap providerMap, IndexStoreView storeView, TokenNameLookup tokenNameLookup, Iterable<IndexRule> indexRules, LogProvider logProvider, IndexingService.Monitor monitor, Runnable schemaStateChangeCallback) {
        if (providerMap == null || providerMap.getDefaultProvider() == null) {
            throw new IllegalStateException("You cannot run the database without an index provider, please make sure that a valid provider (subclass of " + SchemaIndexProvider.class.getName() + ") is on your classpath.");
        }
        IndexSamplingConfig samplingConfig = new IndexSamplingConfig(config);
        MultiPopulatorFactory multiPopulatorFactory = MultiPopulatorFactory.forConfig(config);
        IndexMapReference indexMapRef = new IndexMapReference();
        IndexSamplingControllerFactory factory = new IndexSamplingControllerFactory(samplingConfig, storeView, scheduler, tokenNameLookup, logProvider);
        IndexSamplingController indexSamplingController = factory.create(indexMapRef);
        IndexProxyCreator proxySetup = new IndexProxyCreator(samplingConfig, storeView, providerMap, tokenNameLookup, logProvider);
        return new IndexingService(proxySetup, providerMap, indexMapRef, storeView, indexRules, indexSamplingController, tokenNameLookup, scheduler, schemaStateChangeCallback, multiPopulatorFactory, logProvider, monitor);
    }
}

