/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.RecordProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;

public class SparseNodeFirstRelationshipProcessor
implements RecordProcessor<NodeRecord> {
    private final NodeRelationshipCache cache;

    public SparseNodeFirstRelationshipProcessor(NodeRelationshipCache cache) {
        this.cache = cache;
    }

    @Override
    public boolean process(NodeRecord node) {
        long nodeId = node.getId();
        long firstRel = this.cache.getFirstRel(nodeId, NodeRelationshipCache.NO_GROUP_VISITOR);
        if (firstRel != -1L) {
            node.setNextRel(firstRel);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

