/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.staging.ProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ReadGroupRecordsByCacheStep
extends ProducerStep {
    private final RecordStore<RelationshipGroupRecord> store;
    private final NodeRelationshipCache cache;

    public ReadGroupRecordsByCacheStep(StageControl control, Configuration config, RecordStore<RelationshipGroupRecord> store, NodeRelationshipCache cache) {
        super(control, config);
        this.store = store;
        this.cache = cache;
    }

    @Override
    protected void process() {
        try (NodeVisitor visitor = new NodeVisitor();){
            this.cache.visitChangedNodes(visitor, 1);
        }
    }

    @Override
    protected long position() {
        return this.store.getHighId() * (long)this.store.getRecordSize();
    }

    private class NodeVisitor
    implements NodeRelationshipCache.NodeChangeVisitor,
    AutoCloseable,
    NodeRelationshipCache.GroupVisitor {
        private RelationshipGroupRecord[] batch;
        private int cursor;
        private long time;

        private NodeVisitor() {
            this.batch = new RelationshipGroupRecord[ReadGroupRecordsByCacheStep.this.batchSize];
            this.time = System.nanoTime();
        }

        @Override
        public void change(long nodeId, ByteArray array) {
            ReadGroupRecordsByCacheStep.this.cache.getFirstRel(nodeId, this);
        }

        @Override
        public long visit(long nodeId, int typeId, long out, long in, long loop) {
            long id = ReadGroupRecordsByCacheStep.this.store.nextId();
            RelationshipGroupRecord record = (RelationshipGroupRecord)ReadGroupRecordsByCacheStep.this.store.newRecord();
            record.setId(id);
            this.batch[this.cursor++] = record.initialize(true, typeId, out, in, loop, nodeId, loop);
            if (this.cursor == ReadGroupRecordsByCacheStep.this.batchSize) {
                this.send();
                this.batch = new RelationshipGroupRecord[ReadGroupRecordsByCacheStep.this.batchSize];
                this.cursor = 0;
            }
            return id;
        }

        private void send() {
            ReadGroupRecordsByCacheStep.this.totalProcessingTime.add(System.nanoTime() - this.time);
            ReadGroupRecordsByCacheStep.this.sendDownstream(this.batch);
            this.time = System.nanoTime();
            ReadGroupRecordsByCacheStep.this.assertHealthy();
        }

        @Override
        public void close() {
            if (this.cursor > 0) {
                this.send();
            }
        }
    }
}

