/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogHeaderVisitor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;

public class PhysicalLogicalTransactionStore
implements LogicalTransactionStore {
    private final LogFile logFile;
    private final TransactionMetadataCache transactionMetadataCache;
    private final LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader;
    private static final TransactionMetadataCache.TransactionMetadata METADATA_FOR_EMPTY_STORE = new TransactionMetadataCache.TransactionMetadata(-1, -1, LogPosition.start(0L), 0L, 0L);

    public PhysicalLogicalTransactionStore(LogFile logFile, TransactionMetadataCache transactionMetadataCache, LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader) {
        this.logFile = logFile;
        this.transactionMetadataCache = transactionMetadataCache;
        this.logEntryReader = logEntryReader;
    }

    @Override
    public TransactionCursor getTransactions(LogPosition position) throws IOException {
        return new PhysicalTransactionCursor<ReadableLogChannel>(this.logFile.getReader(position), new VersionAwareLogEntryReader());
    }

    @Override
    public TransactionCursor getTransactions(long transactionIdToStartFrom) throws IOException {
        try {
            TransactionMetadataCache.TransactionMetadata transactionMetadata = this.transactionMetadataCache.getTransactionMetadata(transactionIdToStartFrom);
            if (transactionMetadata != null) {
                ReadableLogChannel channel = this.logFile.getReader(transactionMetadata.getStartPosition());
                return new PhysicalTransactionCursor<ReadableClosablePositionAwareChannel>(channel, this.logEntryReader);
            }
            LogVersionLocator headerVisitor = new LogVersionLocator(transactionIdToStartFrom);
            this.logFile.accept(headerVisitor);
            TransactionPositionLocator transactionPositionLocator = new TransactionPositionLocator(transactionIdToStartFrom, this.logEntryReader);
            this.logFile.accept(transactionPositionLocator, headerVisitor.getLogPosition());
            LogPosition position = transactionPositionLocator.getAndCacheFoundLogPosition(this.transactionMetadataCache);
            return new PhysicalTransactionCursor<ReadableClosablePositionAwareChannel>(this.logFile.getReader(position), this.logEntryReader);
        }
        catch (FileNotFoundException e) {
            throw new NoSuchTransactionException(transactionIdToStartFrom, "Log position acquired, but couldn't find the log file itself. Perhaps it just recently was deleted? [" + e.getMessage() + "]");
        }
    }

    @Override
    public TransactionMetadataCache.TransactionMetadata getMetadataFor(long transactionId) throws IOException {
        if (transactionId <= 1L) {
            return METADATA_FOR_EMPTY_STORE;
        }
        TransactionMetadataCache.TransactionMetadata transactionMetadata = this.transactionMetadataCache.getTransactionMetadata(transactionId);
        if (transactionMetadata == null) {
            try (TransactionCursor cursor = this.getTransactions(transactionId);){
                while (cursor.next()) {
                    CommittedTransactionRepresentation tx = (CommittedTransactionRepresentation)cursor.get();
                    LogEntryCommit commitEntry = tx.getCommitEntry();
                    long committedTxId = commitEntry.getTxId();
                    long timeWritten = commitEntry.getTimeWritten();
                    TransactionMetadataCache.TransactionMetadata metadata = this.transactionMetadataCache.cacheTransactionMetadata(committedTxId, tx.getStartEntry().getStartPosition(), tx.getStartEntry().getMasterId(), tx.getStartEntry().getLocalId(), LogEntryStart.checksum(tx.getStartEntry()), timeWritten);
                    if (committedTxId != transactionId) continue;
                    transactionMetadata = metadata;
                }
            }
            if (transactionMetadata == null) {
                throw new NoSuchTransactionException(transactionId);
            }
        }
        return transactionMetadata;
    }

    public static final class LogVersionLocator
    implements LogHeaderVisitor {
        private final long transactionId;
        private LogPosition foundPosition;

        public LogVersionLocator(long transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public boolean visit(LogPosition position, long firstTransactionIdInLog, long lastTransactionIdInLog) {
            boolean foundIt;
            boolean bl = foundIt = this.transactionId >= firstTransactionIdInLog && this.transactionId <= lastTransactionIdInLog;
            if (foundIt) {
                this.foundPosition = position;
            }
            return !foundIt;
        }

        public LogPosition getLogPosition() throws NoSuchTransactionException {
            if (this.foundPosition == null) {
                throw new NoSuchTransactionException(this.transactionId, "Couldn't find any log containing " + this.transactionId);
            }
            return this.foundPosition;
        }
    }

    public static class TransactionPositionLocator
    implements LogFile.LogFileVisitor {
        private final long startTransactionId;
        private final LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader;
        private LogEntryStart startEntryForFoundTransaction;
        private long commitTimestamp;

        public TransactionPositionLocator(long startTransactionId, LogEntryReader<ReadableClosablePositionAwareChannel> logEntryReader) {
            this.startTransactionId = startTransactionId;
            this.logEntryReader = logEntryReader;
        }

        @Override
        public boolean visit(LogPosition position, ReadableClosablePositionAwareChannel channel) throws IOException {
            LogEntry logEntry;
            LogEntryStart startEntry = null;
            while ((logEntry = this.logEntryReader.readLogEntry(channel)) != null) {
                switch (logEntry.getType()) {
                    case 1: {
                        startEntry = (LogEntryStart)logEntry.as();
                        break;
                    }
                    case 5: {
                        LogEntryCommit commit = (LogEntryCommit)logEntry.as();
                        if (commit.getTxId() != this.startTransactionId) break;
                        this.startEntryForFoundTransaction = startEntry;
                        this.commitTimestamp = commit.getTimeWritten();
                        return false;
                    }
                }
            }
            return true;
        }

        public LogPosition getAndCacheFoundLogPosition(TransactionMetadataCache transactionMetadataCache) throws NoSuchTransactionException {
            if (this.startEntryForFoundTransaction == null) {
                throw new NoSuchTransactionException(this.startTransactionId);
            }
            transactionMetadataCache.cacheTransactionMetadata(this.startTransactionId, this.startEntryForFoundTransaction.getStartPosition(), this.startEntryForFoundTransaction.getMasterId(), this.startEntryForFoundTransaction.getLocalId(), LogEntryStart.checksum(this.startEntryForFoundTransaction), this.commitTimestamp);
            return this.startEntryForFoundTransaction.getStartPosition();
        }
    }
}

