/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.HighIdAwareIterator;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class AllRelationshipIterator
extends HighIdAwareIterator<RelationshipStore>
implements RelationshipIterator {
    private final RelationshipRecord record;
    private long currentId;

    AllRelationshipIterator(RelationshipStore store) {
        super(store);
        this.record = (RelationshipRecord)store.newRecord();
    }

    @Override
    public <EXCEPTION extends Exception> boolean relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> visitor) throws EXCEPTION {
        visitor.visit(relationshipId, this.record.getType(), this.record.getFirstNode(), this.record.getSecondNode());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doFetchNext(long highId) {
        while (this.currentId <= highId) {
            try {
                ((RelationshipStore)this.store).getRecord(this.currentId, this.record, RecordLoad.CHECK);
                if (!this.record.inUse()) continue;
                boolean bl = this.next(this.record.getId());
                return bl;
            }
            finally {
                ++this.currentId;
            }
        }
        return false;
    }
}

