/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.SettingValidator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.logging.Log;

public class IndividualSettingsValidator
implements ConfigurationValidator {
    private static final List<String> reservedPrefixes = Arrays.asList("dbms.", "metrics.", "ha.", "causal_clustering.", "browser.", "tools.", "unsupported.");
    private final boolean warnOnUnknownSettings;

    public IndividualSettingsValidator(boolean warnOnUnknownSettings) {
        this.warnOnUnknownSettings = warnOnUnknownSettings;
    }

    @Override
    @Nonnull
    public Map<String, String> validate(@Nonnull Collection<SettingValidator> settingValidators, @Nonnull Map<String, String> rawConfig, @Nonnull Log log, boolean parsingFile) throws InvalidSettingException {
        Map<String, String> validConfig = settingValidators.stream().map(it -> it.validate(rawConfig, msg -> {
            if (parsingFile) {
                log.warn(msg);
            }
        })).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        boolean strictValidation = (Boolean)GraphDatabaseSettings.strict_config_validation.apply(validConfig::get);
        rawConfig.forEach((key, value) -> {
            if (!validConfig.containsKey(key)) {
                if (reservedPrefixes.stream().anyMatch(key::startsWith)) {
                    if (this.warnOnUnknownSettings) {
                        log.warn("Unknown config option: %s", new Object[]{key});
                    }
                    if (strictValidation) {
                        throw new InvalidSettingException(String.format("Unknown config option '%s'. To resolve either remove it from your configuration or set '%s' to false.", key, GraphDatabaseSettings.strict_config_validation.name()));
                    }
                    validConfig.put((String)key, (String)value);
                } else {
                    validConfig.put((String)key, (String)value);
                }
            }
        });
        return validConfig;
    }
}

